/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.block;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.BlockIdLayout;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.server.ShuffleTaskInfo;
import org.apache.uniffle.server.block.ShuffleBlockIdManager;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionedShuffleBlockIdManager
implements ShuffleBlockIdManager {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionedShuffleBlockIdManager.class);
    private Map<String, Map<Integer, Map<Integer, Roaring64NavigableMap>>> partitionsToBlockIds = new ConcurrentHashMap<String, Map<Integer, Map<Integer, Roaring64NavigableMap>>>();

    @Override
    public void registerAppId(String appId) {
        this.partitionsToBlockIds.computeIfAbsent(appId, key -> JavaUtils.newConcurrentMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addFinishedBlockIds(ShuffleTaskInfo taskInfo, String appId, Integer shuffleId, Map<Integer, long[]> partitionToBlockIds, int bitmapNum) {
        Map<Integer, Map<Integer, Roaring64NavigableMap>> shuffleIdToPartitions = this.partitionsToBlockIds.get(appId);
        if (shuffleIdToPartitions == null) {
            throw new RssException("appId[" + appId + "] is expired!");
        }
        shuffleIdToPartitions.computeIfAbsent(shuffleId, key -> new ConcurrentHashMap());
        Map<Integer, Roaring64NavigableMap> partitions = shuffleIdToPartitions.get(shuffleId);
        int totalUpdatedBlockCount = 0;
        for (Map.Entry<Integer, long[]> entry : partitionToBlockIds.entrySet()) {
            Integer partitionId = entry.getKey();
            partitions.computeIfAbsent(partitionId, k -> Roaring64NavigableMap.bitmapOf((long[])new long[0]));
            Roaring64NavigableMap bitmap = partitions.get(partitionId);
            int updatedBlockCount = 0;
            Roaring64NavigableMap roaring64NavigableMap = bitmap;
            synchronized (roaring64NavigableMap) {
                for (long blockId : entry.getValue()) {
                    if (bitmap.contains(blockId)) continue;
                    bitmap.addLong(blockId);
                    ++updatedBlockCount;
                    ++totalUpdatedBlockCount;
                }
            }
            taskInfo.incBlockNumber(shuffleId, partitionId, updatedBlockCount);
        }
        return totalUpdatedBlockCount;
    }

    @Override
    public byte[] getFinishedBlockIds(ShuffleTaskInfo taskInfo, String appId, Integer shuffleId, Set<Integer> partitions, BlockIdLayout blockIdLayout) throws IOException {
        Map<Integer, Map<Integer, Roaring64NavigableMap>> shuffleIdToPartitions = this.partitionsToBlockIds.get(appId);
        if (shuffleIdToPartitions == null) {
            LOG.warn("Empty blockIds for app: {}. This should not happen", (Object)appId);
            return null;
        }
        Map<Integer, Roaring64NavigableMap> partitionToBlockId = shuffleIdToPartitions.get(shuffleId);
        long expectedBlockNumber = 0L;
        Roaring64NavigableMap res = Roaring64NavigableMap.bitmapOf((long[])new long[0]);
        for (int partitionId : partitions) {
            expectedBlockNumber += taskInfo.getBlockNumber(shuffleId, partitionId);
            Roaring64NavigableMap bitmap = partitionToBlockId.get(partitionId);
            res.or(bitmap);
        }
        if (res.getLongCardinality() != expectedBlockNumber) {
            throw new RssException("Inconsistent block number for partitions: " + partitions + ". Excepted: " + expectedBlockNumber + ", actual: " + res.getLongCardinality());
        }
        return RssUtils.serializeBitMap((Roaring64NavigableMap)res);
    }

    @Override
    public void removeBlockIdByAppId(String appId) {
        this.partitionsToBlockIds.remove(appId);
    }

    @Override
    public void removeBlockIdByShuffleId(String appId, List<Integer> shuffleIds) {
        Optional.ofNullable(this.partitionsToBlockIds.get(appId)).ifPresent(x -> {
            for (Integer shuffleId : shuffleIds) {
                x.remove(shuffleId);
            }
        });
    }

    @Override
    public long getTotalBlockCount() {
        return this.partitionsToBlockIds.values().stream().flatMap(innerMap -> innerMap.values().stream()).flatMap(innerMap -> innerMap.values().stream()).mapToLong(roaringMap -> roaringMap.getLongCardinality()).sum();
    }

    @Override
    public long getBlockCountByShuffleId(String appId, List<Integer> shuffleIds) {
        return this.partitionsToBlockIds.values().stream().filter(k -> shuffleIds.contains(k.keySet())).flatMap(innerMap -> innerMap.values().stream()).flatMap(innerMap -> innerMap.values().stream()).mapToLong(roaringMap -> roaringMap.getLongCardinality()).sum();
    }

    @Override
    public boolean contains(String appId) {
        return this.partitionsToBlockIds.containsKey(appId);
    }

    @Override
    public long getBitmapNum(String appId, int shuffleId) {
        return this.partitionsToBlockIds.get(appId).get(shuffleId).size();
    }
}

