/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.segment;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataSegment;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.segment.SegmentSplitter;
import org.apache.uniffle.shaded.com.google.common.base.Predicate;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSegmentSplitter
implements SegmentSplitter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractSegmentSplitter.class);
    protected int readBufferSize;

    public AbstractSegmentSplitter(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    protected List<ShuffleDataSegment> splitCommon(ShuffleIndexResult shuffleIndexResult, Predicate<Long> taskFilter) {
        if (shuffleIndexResult == null || shuffleIndexResult.isEmpty()) {
            return Lists.newArrayList();
        }
        ByteBuffer indexData = shuffleIndexResult.getIndexData();
        long dataFileLen = shuffleIndexResult.getDataFileLen();
        int[] storageIds = shuffleIndexResult.getStorageIds();
        ArrayList<BufferSegment> bufferSegments = Lists.newArrayList();
        ArrayList<ShuffleDataSegment> dataFileSegments = Lists.newArrayList();
        int bufferOffset = 0;
        long fileOffset = -1L;
        long totalLength = 0L;
        int storageIndex = 0;
        long preOffset = -1L;
        int preStorageId = -1;
        int currentStorageId = 0;
        while (indexData.hasRemaining()) {
            try {
                boolean storageChanged;
                long offset = indexData.getLong();
                int length = indexData.getInt();
                int uncompressLength = indexData.getInt();
                long crc = indexData.getLong();
                long blockId = indexData.getLong();
                long taskAttemptId = indexData.getLong();
                if (storageIds.length == 0) {
                    currentStorageId = -1;
                } else if (preOffset > offset) {
                    if (++storageIndex >= storageIds.length) {
                        LOGGER.warn("storageIds length {} is not enough.", (Object)storageIds.length);
                    }
                    currentStorageId = storageIds[storageIndex];
                } else {
                    currentStorageId = storageIds[storageIndex];
                }
                preOffset = offset;
                if (dataFileLen != -1L && (totalLength += (long)length) > dataFileLen) {
                    LOGGER.info("Abort inconsistent data, the data length: {}(bytes) recorded in index file is greater than the real data file length: {}(bytes). Block id: {}This may happen when the data is flushing, please ignore.", new Object[]{totalLength, dataFileLen, blockId});
                    break;
                }
                boolean bl = storageChanged = preStorageId != -1 && currentStorageId != preStorageId;
                if ((bufferOffset >= this.readBufferSize || storageChanged || taskFilter != null && !taskFilter.test(taskAttemptId)) && bufferOffset > 0) {
                    ShuffleDataSegment sds = new ShuffleDataSegment(fileOffset, bufferOffset, preStorageId, bufferSegments);
                    dataFileSegments.add(sds);
                    bufferSegments = Lists.newArrayList();
                    bufferOffset = 0;
                    fileOffset = -1L;
                }
                if (taskFilter != null && !taskFilter.test(taskAttemptId)) continue;
                if (fileOffset == -1L) {
                    fileOffset = offset;
                }
                bufferSegments.add(new BufferSegment(blockId, bufferOffset, length, uncompressLength, crc, taskAttemptId));
                preStorageId = currentStorageId;
                bufferOffset += length;
            }
            catch (BufferUnderflowException ue) {
                throw new RssException("Read index data under flow", ue);
            }
        }
        if (bufferOffset > 0) {
            ShuffleDataSegment sds = new ShuffleDataSegment(fileOffset, bufferOffset, currentStorageId, bufferSegments);
            dataFileSegments.add(sds);
        }
        return dataFileSegments;
    }
}

