/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.netty.protocol.GetLocalShuffleIndexResponse;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.common.util.Constants;

public class GetLocalShuffleIndexV2Response
extends GetLocalShuffleIndexResponse {
    private final int[] storageIds;

    public GetLocalShuffleIndexV2Response(long requestId, StatusCode statusCode, String retMessage, byte[] indexData, long fileLength) {
        this(requestId, statusCode, retMessage, indexData == null ? Unpooled.EMPTY_BUFFER : Unpooled.wrappedBuffer((byte[])indexData), fileLength);
    }

    public GetLocalShuffleIndexV2Response(long requestId, StatusCode statusCode, String retMessage, ByteBuf indexData, long fileLength) {
        this(requestId, statusCode, retMessage, new NettyManagedBuffer(indexData), fileLength, Constants.EMPTY_INT_ARRAY);
    }

    public GetLocalShuffleIndexV2Response(long requestId, StatusCode statusCode, String retMessage, ManagedBuffer managedBuffer, long fileLength, int[] storageIds) {
        super(requestId, statusCode, retMessage, managedBuffer, fileLength);
        this.storageIds = storageIds;
    }

    @Override
    public int encodedLength() {
        return super.encodedLength() + 4 + 4 * this.storageIds.length;
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        buf.writeInt(this.storageIds.length);
        for (int storageId : this.storageIds) {
            buf.writeInt(storageId);
        }
    }

    public static GetLocalShuffleIndexV2Response decode(ByteBuf byteBuf, boolean decodeBody) {
        long requestId = byteBuf.readLong();
        StatusCode statusCode = StatusCode.fromCode(byteBuf.readInt());
        String retMessage = ByteBufUtils.readLengthAndString(byteBuf);
        long fileLength = byteBuf.readLong();
        int[] storageIds = new int[byteBuf.readInt()];
        for (int i = 0; i < storageIds.length; ++i) {
            storageIds[i] = byteBuf.readInt();
        }
        if (decodeBody) {
            NettyManagedBuffer nettyManagedBuffer = new NettyManagedBuffer(byteBuf);
            return new GetLocalShuffleIndexV2Response(requestId, statusCode, retMessage, nettyManagedBuffer, fileLength, storageIds);
        }
        return new GetLocalShuffleIndexV2Response(requestId, statusCode, retMessage, NettyManagedBuffer.EMPTY_BUFFER, fileLength, storageIds);
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_LOCAL_SHUFFLE_INDEX_V2_RESPONSE;
    }

    @Override
    public int[] getStorageIds() {
        return this.storageIds;
    }
}

