/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.RssMRUtils;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssEventFetcher<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(RssEventFetcher.class);
    private final TaskAttemptID reduce;
    private final TaskUmbilicalProtocol umbilical;
    private int fromEventIdx = 0;
    private final int maxEventsToFetch;
    private JobConf jobConf;
    private List<TaskAttemptID> successMaps = new LinkedList<TaskAttemptID>();
    private List<TaskAttemptID> obsoleteMaps = new LinkedList<TaskAttemptID>();
    private int tipFailedCount = 0;
    private final int totalMapsCount;
    private final int appAttemptId;

    public RssEventFetcher(int appAttemptId, TaskAttemptID reduce, TaskUmbilicalProtocol umbilical, JobConf jobConf, int maxEventsToFetch) {
        this.jobConf = jobConf;
        this.totalMapsCount = jobConf.getNumMapTasks();
        this.reduce = reduce;
        this.umbilical = umbilical;
        this.maxEventsToFetch = maxEventsToFetch;
        this.appAttemptId = appAttemptId;
    }

    public Roaring64NavigableMap fetchAllRssTaskIds() {
        try {
            this.acceptMapCompletionEvents();
        }
        catch (Exception e) {
            throw new RssException("Reduce: " + this.reduce + " fails to accept completion events due to: " + e.getMessage());
        }
        Roaring64NavigableMap taskIdBitmap = Roaring64NavigableMap.bitmapOf(new long[0]);
        Roaring64NavigableMap mapIndexBitmap = Roaring64NavigableMap.bitmapOf(new long[0]);
        String errMsg = "TaskAttemptIDs are inconsistent with map tasks";
        for (TaskAttemptID taskAttemptID : this.successMaps) {
            if (!this.obsoleteMaps.contains(taskAttemptID)) {
                long rssTaskId = RssMRUtils.createRssTaskAttemptId(taskAttemptID, this.appAttemptId, (Configuration)this.jobConf);
                int mapIndex = taskAttemptID.getTaskID().getId();
                if (!mapIndexBitmap.contains(mapIndex)) {
                    taskIdBitmap.addLong(rssTaskId);
                    if (mapIndex < this.totalMapsCount) {
                        mapIndexBitmap.addLong(mapIndex);
                        continue;
                    }
                    LOG.error(taskAttemptID + " has overflowed mapIndex");
                    throw new IllegalStateException(errMsg);
                }
                LOG.warn(taskAttemptID + " is redundant on index: " + mapIndex);
                continue;
            }
            LOG.warn(taskAttemptID + " is successful but cancelled by obsolete event");
        }
        if (mapIndexBitmap.getLongCardinality() != taskIdBitmap.getLongCardinality()) {
            throw new IllegalStateException(errMsg);
        }
        if (this.tipFailedCount != 0) {
            LOG.warn("There are " + this.tipFailedCount + " tipFailed tasks");
        }
        if (taskIdBitmap.getLongCardinality() + (long)this.tipFailedCount != (long)this.totalMapsCount) {
            for (int index = 0; index < this.totalMapsCount; ++index) {
                if (mapIndexBitmap.contains(index)) continue;
                LOG.error("Fail to fetch map task on index: {}", (Object)index);
            }
            throw new IllegalStateException(errMsg);
        }
        return taskIdBitmap;
    }

    public void resolve(TaskCompletionEvent event) {
        switch (event.getTaskStatus()) {
            case SUCCEEDED: {
                this.successMaps.add((TaskAttemptID)event.getTaskAttemptId());
                break;
            }
            case FAILED: 
            case KILLED: 
            case OBSOLETE: {
                this.obsoleteMaps.add((TaskAttemptID)event.getTaskAttemptId());
                LOG.info("Ignoring obsolete output of " + event.getTaskStatus() + " map-task: '" + event.getTaskAttemptId() + "'");
                break;
            }
            case TIPFAILED: {
                ++this.tipFailedCount;
                LOG.info("Ignoring output of failed map TIP: '" + event.getTaskAttemptId() + "'");
                break;
            }
        }
    }

    public void acceptMapCompletionEvents() throws IOException {
        TaskCompletionEvent[] events = null;
        do {
            MapTaskCompletionEventsUpdate update = this.umbilical.getMapCompletionEvents((JobID)this.reduce.getJobID(), this.fromEventIdx, this.maxEventsToFetch, (org.apache.hadoop.mapred.TaskAttemptID)this.reduce);
            events = update.getMapTaskCompletionEvents();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got " + events.length + " map completion events from " + this.fromEventIdx);
            }
            if (update.shouldReset()) {
                throw new RssException("Unexpected legacy state");
            }
            this.fromEventIdx += events.length;
            for (TaskCompletionEvent event : events) {
                this.resolve(event);
            }
        } while (events.length == this.maxEventsToFetch);
    }
}

