/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.clienthints.parsers;

import java.util.Map;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzerDirect;
import nl.basjes.parse.useragent.clienthints.ClientHints;
import nl.basjes.parse.useragent.clienthints.parsers.CHParser;

public class ParseSecChUaPlatform
implements CHParser {
    public static final String HEADER_FIELD = "Sec-CH-UA-Platform";
    public static final String HEADER_SPEC_URL = "https://wicg.github.io/ua-client-hints/#sec-ch-ua-platform";
    public static final String HEADER_SPEC = "The Sec-CH-UA-Platform request header field gives a server information about the platform on which a given user agent is executing. Its value SHOULD match one of the following common platform values: \"Android\", \"Chrome OS\", \"iOS\", \"Linux\", \"macOS\", \"Windows\", or \"Unknown\".";
    public static final String FIELD_NAME = "secChUaPlatform";

    @Override
    @Nonnull
    public ClientHints parse(@Nonnull Map<String, String> clientHintsHeaders, @Nonnull ClientHints clientHints, @Nonnull String headerName) {
        String input = clientHintsHeaders.get(headerName);
        String value = this.parseSfString(input);
        if (value != null && !value.isEmpty()) {
            clientHints.setPlatform(value);
        }
        return clientHints;
    }

    @Override
    @Nonnull
    public String inputField() {
        return HEADER_FIELD;
    }

    public static AbstractUserAgentAnalyzerDirect.HeaderSpecification getHeaderSpecification() {
        return new AbstractUserAgentAnalyzerDirect.HeaderSpecification(HEADER_FIELD, HEADER_SPEC_URL, HEADER_SPEC, FIELD_NAME);
    }
}

