/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.jakarta.util;

import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParseException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.mail2.jakarta.activation.InputStreamDataSource;

public class MimeMessageParser {
    private final MimeMessage mimeMessage;
    private String plainContent;
    private String htmlContent;
    private final List<DataSource> attachmentList = new ArrayList<DataSource>();
    private final Map<String, DataSource> cidMap = new HashMap<String, DataSource>();
    private boolean isMultiPart;

    public MimeMessageParser(MimeMessage mimeMessage) {
        this.mimeMessage = mimeMessage;
        this.isMultiPart = false;
    }

    private List<Address> asList(Address[] recipients) {
        return recipients != null ? Arrays.asList(recipients) : new ArrayList<Address>();
    }

    protected DataSource createDataSource(Multipart parent, MimePart part) throws MessagingException, IOException {
        DataSource dataSource = part.getDataHandler().getDataSource();
        String contentType = this.getBaseMimeType(dataSource.getContentType());
        String dataSourceName = this.getDataSourceName((Part)part, dataSource);
        return new InputStreamDataSource(dataSource.getInputStream(), contentType, dataSourceName);
    }

    public DataSource findAttachmentByCid(String cid) {
        return this.cidMap.get(cid);
    }

    public DataSource findAttachmentByName(String name) {
        for (DataSource dataSource : this.getAttachmentList()) {
            if (!name.equalsIgnoreCase(dataSource.getName())) continue;
            return dataSource;
        }
        return null;
    }

    public List<DataSource> getAttachmentList() {
        return this.attachmentList;
    }

    private String getBaseMimeType(String fullMimeType) {
        int pos = fullMimeType.indexOf(59);
        return pos < 0 ? fullMimeType : fullMimeType.substring(0, pos);
    }

    public List<Address> getBcc() throws MessagingException {
        return this.asList(this.mimeMessage.getRecipients(Message.RecipientType.BCC));
    }

    public List<Address> getCc() throws MessagingException {
        return this.asList(this.mimeMessage.getRecipients(Message.RecipientType.CC));
    }

    public Collection<String> getContentIds() {
        return Collections.unmodifiableSet(this.cidMap.keySet());
    }

    protected String getDataSourceName(Part part, DataSource dataSource) throws MessagingException, UnsupportedEncodingException {
        String result = dataSource.getName();
        if (this.isEmpty(result)) {
            result = part.getFileName();
        }
        result = !this.isEmpty(result) ? MimeUtility.decodeText((String)result) : null;
        return result;
    }

    public String getFrom() throws MessagingException {
        Object[] addresses = this.mimeMessage.getFrom();
        if (this.isEmpty(addresses)) {
            return null;
        }
        return ((InternetAddress)addresses[0]).getAddress();
    }

    public String getHtmlContent() {
        return this.htmlContent;
    }

    public MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    public String getPlainContent() {
        return this.plainContent;
    }

    public String getReplyTo() throws MessagingException {
        Object[] addresses = this.mimeMessage.getReplyTo();
        if (this.isEmpty(addresses)) {
            return null;
        }
        return ((InternetAddress)addresses[0]).getAddress();
    }

    public String getSubject() throws MessagingException {
        return this.mimeMessage.getSubject();
    }

    public List<Address> getTo() throws MessagingException {
        return this.asList(this.mimeMessage.getRecipients(Message.RecipientType.TO));
    }

    public boolean hasAttachments() {
        return !this.attachmentList.isEmpty();
    }

    public boolean hasHtmlContent() {
        return this.htmlContent != null;
    }

    public boolean hasPlainContent() {
        return this.plainContent != null;
    }

    private boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    private boolean isEmpty(String result) {
        return result == null || result.isEmpty();
    }

    private boolean isMimeType(MimePart part, String mimeType) throws MessagingException {
        try {
            return new ContentType(part.getDataHandler().getContentType()).match(mimeType);
        }
        catch (ParseException ex) {
            return part.getContentType().equalsIgnoreCase(mimeType);
        }
    }

    public boolean isMultipart() {
        return this.isMultiPart;
    }

    public MimeMessageParser parse() throws MessagingException, IOException {
        this.parse(null, (MimePart)this.mimeMessage);
        return this;
    }

    protected void parse(Multipart parent, MimePart part) throws MessagingException, IOException {
        if (this.isMimeType(part, "text/plain") && this.plainContent == null && !"attachment".equalsIgnoreCase(part.getDisposition())) {
            this.plainContent = (String)part.getContent();
        } else if (this.isMimeType(part, "text/html") && this.htmlContent == null && !"attachment".equalsIgnoreCase(part.getDisposition())) {
            this.htmlContent = (String)part.getContent();
        } else if (this.isMimeType(part, "multipart/*")) {
            this.isMultiPart = true;
            Multipart multipart = (Multipart)part.getContent();
            int count = multipart.getCount();
            for (int i = 0; i < count; ++i) {
                this.parse(multipart, (MimePart)((MimeBodyPart)multipart.getBodyPart(i)));
            }
        } else {
            String cid = this.stripContentId(part.getContentID());
            DataSource dataSource = this.createDataSource(parent, part);
            if (cid != null) {
                this.cidMap.put(cid, dataSource);
            }
            this.attachmentList.add(dataSource);
        }
    }

    private String stripContentId(String contentId) {
        return contentId == null ? null : contentId.trim().replaceAll("[\\<\\>]", "");
    }
}

