/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.cog;

import java.util.Arrays;
import org.apache.sysds.runtime.io.cog.IFDTag;
import org.apache.sysds.runtime.io.cog.IFDTagDictionary;
import org.apache.sysds.runtime.io.cog.SampleFormatDataTypes;

public class COGProperties {
    private int rows;
    private int cols;
    private int bands;
    private int[] bitsPerSample;
    private SampleFormatDataTypes[] sampleFormat;
    private int planarConfiguration;
    private int tileWidth;
    private int tileLength;
    private int[] tileOffsets;
    private int[] bytesPerTile;
    private int compression;

    public COGProperties() {
    }

    public COGProperties(IFDTag[] ifdTags) {
        this.initFromIFDTags(ifdTags);
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public int getBands() {
        return this.bands;
    }

    public void setBands(int bands) {
        this.bands = bands;
    }

    public int[] getBitsPerSample() {
        return this.bitsPerSample;
    }

    public void setBitsPerSample(int[] bitsPerSample) {
        this.bitsPerSample = bitsPerSample;
    }

    public SampleFormatDataTypes[] getSampleFormat() {
        return this.sampleFormat;
    }

    public void setSampleFormat(SampleFormatDataTypes[] sampleFormat) {
        this.sampleFormat = sampleFormat;
    }

    public int getPlanarConfiguration() {
        return this.planarConfiguration;
    }

    public void setPlanarConfiguration(int planarConfiguration) {
        this.planarConfiguration = planarConfiguration;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public int getTileLength() {
        return this.tileLength;
    }

    public void setTileLength(int tileLength) {
        this.tileLength = tileLength;
    }

    public int[] getTileOffsets() {
        return this.tileOffsets;
    }

    public void setTileOffsets(int[] tileOffsets) {
        this.tileOffsets = tileOffsets;
    }

    public int[] getBytesPerTile() {
        return this.bytesPerTile;
    }

    public void setBytesPerTile(int[] bytesPerTile) {
        this.bytesPerTile = bytesPerTile;
    }

    public int getCompression() {
        return this.compression;
    }

    public void setCompression(int compression) {
        this.compression = compression;
    }

    public void initFromIFDTags(IFDTag[] ifdTags) {
        block13: for (IFDTag ifd : ifdTags) {
            IFDTagDictionary tag = ifd.getTagId();
            switch (tag) {
                case ImageWidth: {
                    this.cols = ifd.getData()[0].intValue();
                    continue block13;
                }
                case ImageLength: {
                    this.rows = ifd.getData()[0].intValue();
                    continue block13;
                }
                case SamplesPerPixel: {
                    this.bands = ifd.getData()[0].intValue();
                    continue block13;
                }
                case BitsPerSample: {
                    this.bitsPerSample = Arrays.stream(ifd.getData()).mapToInt(Number::intValue).toArray();
                    continue block13;
                }
                case TileWidth: {
                    this.tileWidth = ifd.getData()[0].intValue();
                    continue block13;
                }
                case TileLength: {
                    this.tileLength = ifd.getData()[0].intValue();
                    continue block13;
                }
                case TileOffsets: {
                    this.tileOffsets = Arrays.stream(ifd.getData()).mapToInt(Number::intValue).toArray();
                    continue block13;
                }
                case TileByteCounts: {
                    if (ifd.getData() != null) {
                        this.bytesPerTile = Arrays.stream(ifd.getData()).mapToInt(Number::intValue).toArray();
                        continue block13;
                    }
                    this.bytesPerTile = new int[this.tileOffsets.length];
                    for (int tile = 0; tile < this.tileOffsets.length; ++tile) {
                        int bits = 0;
                        for (int band = 0; band < this.bands; ++band) {
                            bits += this.bitsPerSample[band];
                        }
                        this.bytesPerTile[tile] = this.tileWidth * this.tileLength * (bits / 8);
                    }
                    continue block13;
                }
                case SampleFormat: {
                    int dataCount = ifd.getDataCount();
                    this.sampleFormat = new SampleFormatDataTypes[dataCount];
                    for (int i = 0; i < dataCount; ++i) {
                        this.sampleFormat[i] = SampleFormatDataTypes.valueOf(ifd.getData()[i].intValue());
                    }
                    continue block13;
                }
                case PlanarConfiguration: {
                    this.planarConfiguration = ifd.getData()[0].intValue();
                    continue block13;
                }
                case Compression: {
                    this.compression = ifd.getData()[0].intValue();
                    continue block13;
                }
            }
        }
    }

    public boolean tilesFullySequential() {
        boolean tilesFullySequential = true;
        for (int i = 1; i < this.getTileOffsets().length; ++i) {
            if (this.getTileOffsets()[i] >= this.getTileOffsets()[i - 1]) continue;
            tilesFullySequential = false;
            break;
        }
        return tilesFullySequential;
    }
}

