/*
 * Decompiled with CFR 0.152.
 */
package com.google.transconsole.common.messages;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.transconsole.common.messages.BundleFormat;
import com.google.transconsole.common.messages.MessageFragment;
import com.google.transconsole.common.messages.TextFragment;
import java.util.List;

public final class Placeholder
implements MessageFragment {
    public static final String VALID_PLACEHOLDER_REG_EXP = "^[A-Z0-9_]+$";
    private final String original;
    private final String presentation;
    private final String example;

    public Placeholder(String original, String presentation, String example) {
        this.original = Preconditions.checkNotNull(original);
        this.presentation = Preconditions.checkNotNull(presentation);
        this.example = Preconditions.checkNotNull(example);
    }

    public Placeholder(String original, String presentation) {
        this(original, presentation, "");
    }

    public Placeholder(String presentation) {
        this.original = null;
        this.presentation = Preconditions.checkNotNull(presentation);
        this.example = null;
    }

    public String toString() {
        return this.original;
    }

    @Override
    public String getOriginal() {
        return this.toString();
    }

    @Override
    public String getPresentation() {
        return this.presentation;
    }

    public String getExample() {
        return this.example;
    }

    @Override
    public String toXml(BundleFormat format) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ph name=\"");
        sb.append(CharEscapers.xmlEscaper().escape(this.presentation));
        sb.append("\"");
        if (format.equals((Object)BundleFormat.XMB)) {
            sb.append(">");
            if (this.example != null) {
                sb.append("<ex>");
                sb.append(CharEscapers.xmlContentEscaper().escape(this.example));
                sb.append("</ex>");
            }
            if (this.original != null) {
                sb.append(CharEscapers.xmlContentEscaper().escape(this.original));
            }
            sb.append("</ph>");
        } else {
            sb.append("/>");
        }
        return sb.toString();
    }

    @Override
    public boolean conflictsWith(MessageFragment f) {
        if (!(f instanceof Placeholder)) {
            return false;
        }
        Placeholder p = (Placeholder)f;
        return p.getPresentation().equals(this.getPresentation()) && (!p.getOriginal().equals(this.getOriginal()) || !p.getExample().equals(this.getExample()));
    }

    @Override
    public void partialNormalize(StringBuilder sb, List<? super MessageFragment> output) {
        if (sb.length() > 0) {
            output.add(new TextFragment(sb.toString()));
            sb.setLength(0);
        }
        output.add(this);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Placeholder && this.equals((Placeholder)that);
    }

    public boolean equals(Placeholder that) {
        return Objects.equal(this.getOriginal(), that.getOriginal()) && Objects.equal(this.getPresentation(), that.getPresentation()) && Objects.equal(this.getExample(), that.getExample());
    }

    public int hashCode() {
        return Objects.hashCode(this.getOriginal(), this.getPresentation(), this.getExample());
    }
}

