/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public abstract class AbstractCheckpointStats
implements Serializable {
    private static final long serialVersionUID = 1041218202028265151L;
    final long checkpointId;
    final long triggerTimestamp;
    final Map<JobVertexID, TaskStateStats> taskStats;
    final int numberOfSubtasks;
    final CheckpointProperties props;

    AbstractCheckpointStats(long checkpointId, long triggerTimestamp, CheckpointProperties props, int numberOfSubtasks, Map<JobVertexID, TaskStateStats> taskStats) {
        this.checkpointId = checkpointId;
        this.triggerTimestamp = triggerTimestamp;
        this.taskStats = (Map)Preconditions.checkNotNull(taskStats);
        Preconditions.checkArgument((taskStats.size() > 0 ? 1 : 0) != 0, (Object)"Empty task stats");
        Preconditions.checkArgument((numberOfSubtasks > 0 ? 1 : 0) != 0, (Object)"Non-positive number of subtasks");
        this.numberOfSubtasks = numberOfSubtasks;
        this.props = (CheckpointProperties)Preconditions.checkNotNull((Object)props);
    }

    public abstract CheckpointStatsStatus getStatus();

    public abstract int getNumberOfAcknowledgedSubtasks();

    public abstract long getStateSize();

    public abstract long getProcessedData();

    public abstract long getPersistedData();

    @Nullable
    public abstract SubtaskStateStats getLatestAcknowledgedSubtaskStats();

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public long getTriggerTimestamp() {
        return this.triggerTimestamp;
    }

    public CheckpointProperties getProperties() {
        return this.props;
    }

    public int getNumberOfSubtasks() {
        return this.numberOfSubtasks;
    }

    public TaskStateStats getTaskStateStats(JobVertexID jobVertexId) {
        return this.taskStats.get(jobVertexId);
    }

    public Collection<TaskStateStats> getAllTaskStateStats() {
        return this.taskStats.values();
    }

    public long getLatestAckTimestamp() {
        SubtaskStateStats subtask = this.getLatestAcknowledgedSubtaskStats();
        if (subtask != null) {
            return subtask.getAckTimestamp();
        }
        return -1L;
    }

    public long getEndToEndDuration() {
        SubtaskStateStats subtask = this.getLatestAcknowledgedSubtaskStats();
        if (subtask != null) {
            return Math.max(0L, subtask.getAckTimestamp() - this.triggerTimestamp);
        }
        return -1L;
    }
}

