/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.pipelines;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.OutputType;
import org.apache.spark.connect.proto.PipelineCommand;
import org.apache.spark.connect.proto.PipelineCommandResult;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.ResolvedIdentifier;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.CreateNamespace;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.CreateView;
import org.apache.spark.sql.catalyst.plans.logical.DescribeRelation;
import org.apache.spark.sql.catalyst.plans.logical.DropView;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.RenameTable;
import org.apache.spark.sql.catalyst.plans.logical.ShowColumns;
import org.apache.spark.sql.catalyst.plans.logical.ShowCreateTable;
import org.apache.spark.sql.catalyst.plans.logical.ShowFunctions;
import org.apache.spark.sql.catalyst.plans.logical.ShowTableProperties;
import org.apache.spark.sql.catalyst.plans.logical.ShowTables;
import org.apache.spark.sql.catalyst.plans.logical.ShowViews;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.pipelines.PipelineEventSender;
import org.apache.spark.sql.connect.pipelines.PipelinesHandler;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.execution.command.ShowCatalogsCommand;
import org.apache.spark.sql.execution.command.ShowNamespacesCommand;
import org.apache.spark.sql.pipelines.Language;
import org.apache.spark.sql.pipelines.common.RunState;
import org.apache.spark.sql.pipelines.graph.AllTables$;
import org.apache.spark.sql.pipelines.graph.FlowAnalysis$;
import org.apache.spark.sql.pipelines.graph.FlowFunction;
import org.apache.spark.sql.pipelines.graph.GraphIdentifierManager$;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext;
import org.apache.spark.sql.pipelines.graph.IdentifierHelper$;
import org.apache.spark.sql.pipelines.graph.NoTables$;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContext;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContextImpl;
import org.apache.spark.sql.pipelines.graph.QueryContext;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.QueryOrigin$;
import org.apache.spark.sql.pipelines.graph.QueryOriginType$;
import org.apache.spark.sql.pipelines.graph.Sink;
import org.apache.spark.sql.pipelines.graph.SinkImpl;
import org.apache.spark.sql.pipelines.graph.SomeTables;
import org.apache.spark.sql.pipelines.graph.SqlGraphRegistrationContext;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.TableFilter;
import org.apache.spark.sql.pipelines.graph.TemporaryView;
import org.apache.spark.sql.pipelines.graph.UnresolvedFlow;
import org.apache.spark.sql.pipelines.graph.View;
import org.apache.spark.sql.pipelines.logging.EventDetails;
import org.apache.spark.sql.pipelines.logging.PipelineEvent;
import org.apache.spark.sql.pipelines.logging.RunProgress;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Using;
import scala.util.Using$;

public final class PipelinesHandler$
implements Logging {
    public static final PipelinesHandler$ MODULE$ = new PipelinesHandler$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public PipelineCommandResult handlePipelinesCommand(SessionHolder sessionHolder, PipelineCommand cmd, StreamObserver<ExecutePlanResponse> responseObserver, Function1<Relation, LogicalPlan> transformRelationFunc) {
        PipelineCommandResult defaultResponse = PipelineCommandResult.getDefaultInstance();
        PipelineCommand.CommandTypeCase commandTypeCase = cmd.getCommandTypeCase();
        if (PipelineCommand.CommandTypeCase.CREATE_DATAFLOW_GRAPH.equals(commandTypeCase)) {
            String createdGraphId = this.createDataflowGraph(cmd.getCreateDataflowGraph(), sessionHolder);
            return PipelineCommandResult.newBuilder().setCreateDataflowGraphResult(PipelineCommandResult.CreateDataflowGraphResult.newBuilder().setDataflowGraphId(createdGraphId).build()).build();
        }
        if (PipelineCommand.CommandTypeCase.DROP_DATAFLOW_GRAPH.equals(commandTypeCase)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Drop pipeline cmd received: " + cmd);
            sessionHolder.dataflowGraphRegistry().dropDataflowGraph(cmd.getDropDataflowGraph().getDataflowGraphId());
            return defaultResponse;
        }
        if (PipelineCommand.CommandTypeCase.DEFINE_OUTPUT.equals(commandTypeCase)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Define pipelines output cmd received: " + cmd);
            TableIdentifier resolvedDataset = this.defineOutput(cmd.getDefineOutput(), sessionHolder);
            ResolvedIdentifier.Builder identifierBuilder = ResolvedIdentifier.newBuilder();
            resolvedDataset.catalog().foreach((Function1 & Serializable)x$1 -> identifierBuilder.setCatalogName((String)x$1));
            resolvedDataset.database().foreach((Function1 & Serializable)ns -> identifierBuilder.addNamespace((String)ns));
            identifierBuilder.setTableName(resolvedDataset.identifier());
            ResolvedIdentifier identifier = identifierBuilder.build();
            return PipelineCommandResult.newBuilder().setDefineOutputResult(PipelineCommandResult.DefineOutputResult.newBuilder().setResolvedIdentifier(identifier).build()).build();
        }
        if (PipelineCommand.CommandTypeCase.DEFINE_FLOW.equals(commandTypeCase)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Define pipelines flow cmd received: " + cmd);
            TableIdentifier resolvedFlow = this.defineFlow(cmd.getDefineFlow(), transformRelationFunc, sessionHolder);
            ResolvedIdentifier.Builder identifierBuilder = ResolvedIdentifier.newBuilder();
            resolvedFlow.catalog().foreach((Function1 & Serializable)x$1 -> identifierBuilder.setCatalogName((String)x$1));
            resolvedFlow.database().foreach((Function1 & Serializable)ns -> identifierBuilder.addNamespace((String)ns));
            identifierBuilder.setTableName(resolvedFlow.identifier());
            ResolvedIdentifier identifier = identifierBuilder.build();
            return PipelineCommandResult.newBuilder().setDefineFlowResult(PipelineCommandResult.DefineFlowResult.newBuilder().setResolvedIdentifier(identifierBuilder).build()).build();
        }
        if (PipelineCommand.CommandTypeCase.START_RUN.equals(commandTypeCase)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Start pipeline cmd received: " + cmd);
            this.startRun(cmd.getStartRun(), responseObserver, sessionHolder);
            return defaultResponse;
        }
        if (PipelineCommand.CommandTypeCase.DEFINE_SQL_GRAPH_ELEMENTS.equals(commandTypeCase)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Register sql datasets cmd received: " + cmd);
            this.defineSqlGraphElements(cmd.getDefineSqlGraphElements(), sessionHolder);
            return defaultResponse;
        }
        throw new UnsupportedOperationException(commandTypeCase + " not supported");
    }

    public void blockUnsupportedSqlCommand(LogicalPlan queryPlan) {
        boolean isUnsupportedSqlPlan;
        scala.collection.immutable.Set allowlistedCommands = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{DescribeRelation.class, ShowTables.class, ShowTableProperties.class, ShowNamespacesCommand.class, ShowColumns.class, ShowFunctions.class, ShowViews.class, ShowCatalogsCommand.class, ShowCreateTable.class}));
        boolean isSqlCommandExplicitlyAllowlisted = allowlistedCommands.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isInstance(queryPlan)));
        boolean bl = isSqlCommandExplicitlyAllowlisted ? false : (isUnsupportedSqlPlan = queryPlan instanceof Command || queryPlan instanceof CreateTableAsSelect || queryPlan instanceof CreateTable || queryPlan instanceof CreateView || queryPlan instanceof InsertIntoStatement || queryPlan instanceof RenameTable || queryPlan instanceof CreateNamespace || queryPlan instanceof DropView);
        if (isUnsupportedSqlPlan) {
            throw new AnalysisException("UNSUPPORTED_PIPELINE_SPARK_SQL_COMMAND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"command"), (Object)queryPlan.getClass().getSimpleName())})));
        }
    }

    private String createDataflowGraph(PipelineCommand.CreateDataflowGraph cmd, SessionHolder sessionHolder) {
        String defaultCatalog = (String)Option$.MODULE$.when(cmd.hasDefaultCatalog(), (Function0 & Serializable)() -> cmd.getDefaultCatalog()).getOrElse((Function0 & Serializable)() -> {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "No default catalog was supplied. Falling back to the current catalog.");
            return sessionHolder.session().catalog().currentCatalog();
        });
        String defaultDatabase = (String)Option$.MODULE$.when(cmd.hasDefaultDatabase(), (Function0 & Serializable)() -> cmd.getDefaultDatabase()).getOrElse((Function0 & Serializable)() -> {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "No default database was supplied. Falling back to the current database.");
            return sessionHolder.session().catalog().currentDatabase();
        });
        scala.collection.immutable.Map defaultSqlConf = CollectionConverters$.MODULE$.MapHasAsScala(cmd.getSqlConfMap()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        sessionHolder.session().catalog().setCurrentCatalog(defaultCatalog);
        sessionHolder.session().catalog().setCurrentDatabase(defaultDatabase);
        return sessionHolder.dataflowGraphRegistry().createDataflowGraph(defaultCatalog, defaultDatabase, (scala.collection.immutable.Map<String, String>)defaultSqlConf);
    }

    private void defineSqlGraphElements(PipelineCommand.DefineSqlGraphElements cmd, SessionHolder sessionHolder) {
        String dataflowGraphId = cmd.getDataflowGraphId();
        GraphRegistrationContext graphElementRegistry = sessionHolder.dataflowGraphRegistry().getDataflowGraphOrThrow(dataflowGraphId);
        SqlGraphRegistrationContext sqlGraphElementRegistrationContext = new SqlGraphRegistrationContext(graphElementRegistry);
        sqlGraphElementRegistrationContext.processSqlFile(cmd.getSqlText(), cmd.getSqlFilePath(), (SparkSession)sessionHolder.session());
    }

    private TableIdentifier defineOutput(PipelineCommand.DefineOutput output, SessionHolder sessionHolder) {
        String dataflowGraphId = output.getDataflowGraphId();
        GraphRegistrationContext graphElementRegistry = sessionHolder.dataflowGraphRegistry().getDataflowGraphOrThrow(dataflowGraphId);
        OutputType outputType = output.getOutputType();
        if (OutputType.MATERIALIZED_VIEW.equals(outputType) ? true : OutputType.TABLE.equals(outputType)) {
            Some some;
            TableIdentifier qualifiedIdentifier = GraphIdentifierManager$.MODULE$.parseAndQualifyTableIdentifier(GraphIdentifierManager$.MODULE$.parseTableIdentifier(output.getOutputName(), sessionHolder.session()), (Option)new Some((Object)graphElementRegistry.defaultCatalog()), (Option)new Some((Object)graphElementRegistry.defaultDatabase())).identifier();
            PipelineCommand.DefineOutput.TableDetails tableDetails = output.getTableDetails();
            TableIdentifier x$8 = qualifiedIdentifier;
            Option x$9 = Option$.MODULE$.apply((Object)output.getComment());
            PipelineCommand.DefineOutput.TableDetails.SchemaCase schemaCase = tableDetails.getSchemaCase();
            if (PipelineCommand.DefineOutput.TableDetails.SchemaCase.SCHEMA_DATA_TYPE.equals(schemaCase)) {
                some = new Some((Object)((StructType)DataTypeProtoConverter$.MODULE$.toCatalystType(tableDetails.getSchemaDataType())));
            } else if (PipelineCommand.DefineOutput.TableDetails.SchemaCase.SCHEMA_STRING.equals(schemaCase)) {
                some = new Some((Object)StructType$.MODULE$.fromDDL(tableDetails.getSchemaString()));
            } else if (PipelineCommand.DefineOutput.TableDetails.SchemaCase.SCHEMA_NOT_SET.equals(schemaCase)) {
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)schemaCase);
            }
            Some x$10 = some;
            Option x$11 = Option$.MODULE$.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)tableDetails.getPartitionColsList()).asScala().toSeq()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
            Option x$12 = Option$.MODULE$.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)tableDetails.getClusteringColumnsList()).asScala().toSeq()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty()));
            scala.collection.immutable.Map x$13 = CollectionConverters$.MODULE$.MapHasAsScala(tableDetails.getTablePropertiesMap()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Option x$1 = Option$.MODULE$.when(output.getSourceCodeLocation().hasFileName(), (Function0 & Serializable)() -> output.getSourceCodeLocation().getFileName());
            Option x$22 = Option$.MODULE$.when(output.getSourceCodeLocation().hasLineNumber(), (Function0)(JFunction0.mcI.sp & Serializable)() -> output.getSourceCodeLocation().getLineNumber());
            Option x$32 = Option$.MODULE$.apply((Object)QueryOriginType$.MODULE$.Table().toString());
            Option x$4 = Option$.MODULE$.apply((Object)qualifiedIdentifier.unquotedString());
            Option x$5 = Option$.MODULE$.apply((Object)new Language.Python());
            Option x$6 = QueryOrigin$.MODULE$.apply$default$3();
            Option x$7 = QueryOrigin$.MODULE$.apply$default$5();
            QueryOrigin x$14 = new QueryOrigin(x$5, x$1, x$6, x$22, x$7, x$32, x$4);
            Option x$15 = Option$.MODULE$.when(tableDetails.hasFormat(), (Function0 & Serializable)() -> tableDetails.getFormat());
            None$ x$16 = None$.MODULE$;
            OutputType outputType2 = output.getOutputType();
            OutputType outputType3 = OutputType.TABLE;
            boolean x$17 = !(outputType2 != null ? !outputType2.equals(outputType3) : outputType3 != null);
            graphElementRegistry.registerTable(new Table(x$8, (Option)x$10, x$11, x$12, (Option)x$16, x$13, x$9, x$14, x$17, x$15));
            return qualifiedIdentifier;
        }
        if (OutputType.TEMPORARY_VIEW.equals(outputType)) {
            TableIdentifier viewIdentifier;
            TableIdentifier x$25 = viewIdentifier = GraphIdentifierManager$.MODULE$.parseAndValidateTemporaryViewIdentifier(GraphIdentifierManager$.MODULE$.parseTableIdentifier(output.getOutputName(), sessionHolder.session()));
            Option x$26 = Option$.MODULE$.apply((Object)output.getComment());
            Option x$18 = Option$.MODULE$.when(output.getSourceCodeLocation().hasFileName(), (Function0 & Serializable)() -> output.getSourceCodeLocation().getFileName());
            Option x$19 = Option$.MODULE$.when(output.getSourceCodeLocation().hasLineNumber(), (Function0)(JFunction0.mcI.sp & Serializable)() -> output.getSourceCodeLocation().getLineNumber());
            Option x$20 = Option$.MODULE$.apply((Object)QueryOriginType$.MODULE$.View().toString());
            Option x$21 = Option$.MODULE$.apply((Object)viewIdentifier.unquotedString());
            Option x$22 = Option$.MODULE$.apply((Object)new Language.Python());
            Option x$23 = QueryOrigin$.MODULE$.apply$default$3();
            Option x$24 = QueryOrigin$.MODULE$.apply$default$5();
            QueryOrigin x$27 = new QueryOrigin(x$22, x$18, x$23, x$19, x$24, x$20, x$21);
            scala.collection.immutable.Map x$28 = Predef$.MODULE$.Map().empty();
            None$ x$29 = None$.MODULE$;
            graphElementRegistry.registerView((View)new TemporaryView(x$25, x$28, (Option)x$29, x$26, x$27));
            return viewIdentifier;
        }
        if (OutputType.SINK.equals(outputType)) {
            String dataflowGraphId2 = output.getDataflowGraphId();
            GraphRegistrationContext graphElementRegistry2 = sessionHolder.dataflowGraphRegistry().getDataflowGraphOrThrow(dataflowGraphId2);
            TableIdentifier identifier = GraphIdentifierManager$.MODULE$.parseTableIdentifier(output.getOutputName(), sessionHolder.session());
            PipelineCommand.DefineOutput.SinkDetails sinkDetails = output.getSinkDetails();
            Option x$30 = Option$.MODULE$.when(output.getSourceCodeLocation().hasFileName(), (Function0 & Serializable)() -> output.getSourceCodeLocation().getFileName());
            Option x$31 = Option$.MODULE$.when(output.getSourceCodeLocation().hasLineNumber(), (Function0)(JFunction0.mcI.sp & Serializable)() -> output.getSourceCodeLocation().getLineNumber());
            Option x$32 = Option$.MODULE$.apply((Object)QueryOriginType$.MODULE$.Sink().toString());
            Option x$33 = Option$.MODULE$.apply((Object)identifier.unquotedString());
            Option x$34 = Option$.MODULE$.apply((Object)new Language.Python());
            Option x$35 = QueryOrigin$.MODULE$.apply$default$3();
            Option x$36 = QueryOrigin$.MODULE$.apply$default$5();
            graphElementRegistry2.registerSink((Sink)new SinkImpl(identifier, sinkDetails.getFormat(), CollectionConverters$.MODULE$.MapHasAsScala(sinkDetails.getOptionsMap()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), new QueryOrigin(x$34, x$30, x$35, x$31, x$36, x$32, x$33)));
            return identifier;
        }
        throw new IllegalArgumentException("Unknown output type: " + output.getOutputType());
    }

    private TableIdentifier defineFlow(PipelineCommand.DefineFlow flow, Function1<Relation, LogicalPlan> transformRelationFunc, SessionHolder sessionHolder) {
        SeqOps seqOps;
        boolean flowWritesToSink;
        if (flow.hasOnce()) {
            throw new AnalysisException("DEFINE_FLOW_ONCE_OPTION_NOT_SUPPORTED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowName"), (Object)flow.getFlowName())})));
        }
        String dataflowGraphId = flow.getDataflowGraphId();
        GraphRegistrationContext graphElementRegistry = sessionHolder.dataflowGraphRegistry().getDataflowGraphOrThrow(dataflowGraphId);
        String defaultCatalog = graphElementRegistry.defaultCatalog();
        String defaultDatabase = graphElementRegistry.defaultDatabase();
        String string = flow.getFlowName();
        String string2 = flow.getTargetDatasetName();
        boolean isImplicitFlow = !(string != null ? !string.equals(string2) : string2 != null);
        TableIdentifier rawFlowIdentifier = GraphIdentifierManager$.MODULE$.parseTableIdentifier(flow.getFlowName(), sessionHolder.session());
        if (!isImplicitFlow && !IdentifierHelper$.MODULE$.isSinglePartIdentifier(rawFlowIdentifier)) {
            throw new AnalysisException("MULTIPART_FLOW_NAME_NOT_SUPPORTED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowName"), (Object)flow.getFlowName())})));
        }
        TableIdentifier rawDestinationIdentifier = GraphIdentifierManager$.MODULE$.parseTableIdentifier(flow.getTargetDatasetName(), sessionHolder.session());
        boolean flowWritesToView = ((IterableOnceOps)graphElementRegistry.getViews().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PipelinesHandler$.$anonfun$defineFlow$1(x$4)))).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PipelinesHandler$.$anonfun$defineFlow$2(rawDestinationIdentifier, x$5)));
        boolean isImplicitFlowForTempView = isImplicitFlow && flowWritesToView;
        Seq seq = (Seq)new .colon.colon((Object)rawFlowIdentifier, (List)new .colon.colon((Object)rawDestinationIdentifier, (List)Nil$.MODULE$)).map(arg_0 -> PipelinesHandler$.$anonfun$defineFlow$5(isImplicitFlowForTempView, flowWritesToSink = ((IterableOnceOps)graphElementRegistry.getSinks().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PipelinesHandler$.$anonfun$defineFlow$3(x$6)))).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PipelinesHandler$.$anonfun$defineFlow$4(rawDestinationIdentifier, x$7))), defaultCatalog, defaultDatabase, arg_0));
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) {
            throw new MatchError((Object)seq);
        }
        TableIdentifier flowIdentifier = (TableIdentifier)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        TableIdentifier destinationIdentifier = (TableIdentifier)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        Tuple2 tuple2 = new Tuple2((Object)flowIdentifier, (Object)destinationIdentifier);
        TableIdentifier flowIdentifier2 = (TableIdentifier)tuple2._1();
        TableIdentifier destinationIdentifier2 = (TableIdentifier)tuple2._2();
        PipelineCommand.DefineFlow.WriteRelationFlowDetails relationFlowDetails = flow.getRelationFlowDetails();
        TableIdentifier x$8 = flowIdentifier2;
        TableIdentifier x$9 = destinationIdentifier2;
        FlowFunction x$10 = FlowAnalysis$.MODULE$.createFlowFunctionFromLogicalPlan((LogicalPlan)transformRelationFunc.apply((Object)relationFlowDetails.getRelation()));
        scala.collection.immutable.Map x$11 = CollectionConverters$.MODULE$.MapHasAsScala(flow.getSqlConfMap()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        boolean x$12 = false;
        QueryContext x$13 = new QueryContext(Option$.MODULE$.apply((Object)defaultCatalog), Option$.MODULE$.apply((Object)defaultDatabase));
        Option x$1 = Option$.MODULE$.when(flow.getSourceCodeLocation().hasFileName(), (Function0 & Serializable)() -> flow.getSourceCodeLocation().getFileName());
        Option x$2 = Option$.MODULE$.when(flow.getSourceCodeLocation().hasLineNumber(), (Function0)(JFunction0.mcI.sp & Serializable)() -> flow.getSourceCodeLocation().getLineNumber());
        Option x$3 = Option$.MODULE$.apply((Object)QueryOriginType$.MODULE$.Flow().toString());
        Option x$42 = Option$.MODULE$.apply((Object)flowIdentifier2.unquotedString());
        Option x$52 = Option$.MODULE$.apply((Object)new Language.Python());
        Option x$62 = QueryOrigin$.MODULE$.apply$default$3();
        Option x$72 = QueryOrigin$.MODULE$.apply$default$5();
        QueryOrigin x$14 = new QueryOrigin(x$52, x$1, x$62, x$2, x$72, x$3, x$42);
        graphElementRegistry.registerFlow(new UnresolvedFlow(x$8, x$9, x$10, x$13, x$11, false, x$14));
        return flowIdentifier2;
    }

    private void startRun(PipelineCommand.StartRun cmd, StreamObserver<ExecutePlanResponse> responseObserver, SessionHolder sessionHolder) {
        String dataflowGraphId = cmd.getDataflowGraphId();
        GraphRegistrationContext graphElementRegistry = sessionHolder.dataflowGraphRegistry().getDataflowGraphOrThrow(dataflowGraphId);
        PipelinesHandler.TableFilters tableFiltersResult = this.createTableFilters(cmd, graphElementRegistry, sessionHolder);
        Using$.MODULE$.resource((Object)new PipelineEventSender(responseObserver, sessionHolder), (Function1 & Serializable)eventSender -> {
            PipelinesHandler$.$anonfun$startRun$1(cmd, graphElementRegistry, tableFiltersResult, sessionHolder, dataflowGraphId, eventSender);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private PipelinesHandler.TableFilters createTableFilters(PipelineCommand.StartRun startRunCommand, GraphRegistrationContext graphElementRegistry, SessionHolder sessionHolder) {
        scala.collection.immutable.Seq seq;
        scala.collection.immutable.Seq seq2;
        scala.collection.immutable.Set intersection;
        scala.collection.immutable.Seq fullRefreshTables = CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)startRunCommand.getFullRefreshSelectionList()).asScala().toSeq();
        boolean fullRefreshAll = startRunCommand.getFullRefreshAll();
        scala.collection.immutable.Seq refreshTables = CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)startRunCommand.getRefreshSelectionList()).asScala().toSeq();
        if (refreshTables.nonEmpty() && fullRefreshAll) {
            throw new IllegalArgumentException("Cannot specify a subset to refresh when full refresh all is set to true.");
        }
        if (fullRefreshTables.nonEmpty() && fullRefreshAll) {
            throw new IllegalArgumentException("Cannot specify a subset to full refresh when full refresh all is set to true.");
        }
        scala.collection.immutable.Set refreshTableNames = PipelinesHandler$.parseTableNames$1((Seq)refreshTables, sessionHolder, graphElementRegistry);
        scala.collection.immutable.Set fullRefreshTableNames = PipelinesHandler$.parseTableNames$1((Seq)fullRefreshTables, sessionHolder, graphElementRegistry);
        if (refreshTables.nonEmpty() && fullRefreshTables.nonEmpty() && (intersection = (scala.collection.immutable.Set)refreshTableNames.intersect((Set)fullRefreshTableNames)).nonEmpty()) {
            throw new IllegalArgumentException("Datasets specified for refresh and full refresh cannot overlap: " + intersection.mkString(", "));
        }
        if (fullRefreshAll) {
            return new PipelinesHandler.TableFilters((TableFilter)AllTables$.MODULE$, (TableFilter)NoTables$.MODULE$);
        }
        Tuple2 tuple2 = new Tuple2((Object)fullRefreshTables, (Object)refreshTables);
        if (tuple2 != null) {
            scala.collection.immutable.Seq seq3 = (scala.collection.immutable.Seq)tuple2._1();
            scala.collection.immutable.Seq seq4 = (scala.collection.immutable.Seq)tuple2._2();
            if (Nil$.MODULE$.equals(seq3) && Nil$.MODULE$.equals(seq4)) {
                return new PipelinesHandler.TableFilters((TableFilter)NoTables$.MODULE$, (TableFilter)AllTables$.MODULE$);
            }
        }
        if (tuple2 != null && Nil$.MODULE$.equals(seq2 = (scala.collection.immutable.Seq)tuple2._2())) {
            return new PipelinesHandler.TableFilters((TableFilter)new SomeTables(fullRefreshTableNames), (TableFilter)NoTables$.MODULE$);
        }
        if (tuple2 != null && Nil$.MODULE$.equals(seq = (scala.collection.immutable.Seq)tuple2._1())) {
            return new PipelinesHandler.TableFilters((TableFilter)NoTables$.MODULE$, (TableFilter)new SomeTables(refreshTableNames));
        }
        if (tuple2 != null) {
            return new PipelinesHandler.TableFilters((TableFilter)new SomeTables(fullRefreshTableNames), (TableFilter)new SomeTables(refreshTableNames));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$defineFlow$1(View x$4) {
        return x$4 instanceof TemporaryView;
    }

    public static final /* synthetic */ boolean $anonfun$defineFlow$2(TableIdentifier rawDestinationIdentifier$1, View x$5) {
        TableIdentifier tableIdentifier = x$5.identifier();
        TableIdentifier tableIdentifier2 = rawDestinationIdentifier$1;
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$defineFlow$3(Sink x$6) {
        return x$6 instanceof Sink;
    }

    public static final /* synthetic */ boolean $anonfun$defineFlow$4(TableIdentifier rawDestinationIdentifier$1, Sink x$7) {
        TableIdentifier tableIdentifier = x$7.identifier();
        TableIdentifier tableIdentifier2 = rawDestinationIdentifier$1;
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ TableIdentifier $anonfun$defineFlow$5(boolean isImplicitFlowForTempView$1, boolean flowWritesToSink$1, String defaultCatalog$1, String defaultDatabase$1, TableIdentifier rawIdentifier) {
        if (isImplicitFlowForTempView$1 || flowWritesToSink$1) {
            return rawIdentifier;
        }
        return GraphIdentifierManager$.MODULE$.parseAndQualifyFlowIdentifier(rawIdentifier, (Option)new Some((Object)defaultCatalog$1), (Option)new Some((Object)defaultDatabase$1)).identifier();
    }

    public static final /* synthetic */ void $anonfun$startRun$2(VolatileObjectRef runFailureEvent$1, PipelineEventSender eventSender$1, PipelineEvent event) {
        boolean bl = false;
        RunProgress runProgress = null;
        EventDetails eventDetails = event.details();
        if (eventDetails instanceof RunProgress) {
            RunState state;
            bl = true;
            runProgress = (RunProgress)eventDetails;
            RunState runState = state = runProgress.state();
            RunState.FAILED$ fAILED$ = RunState.FAILED$.MODULE$;
            if (!(runState != null ? !runState.equals(fAILED$) : fAILED$ != null)) {
                runFailureEvent$1.elem = new Some((Object)event);
                return;
            }
        }
        if (bl) {
            RunState state;
            RunState runState = state = runProgress.state();
            RunState.CANCELED$ cANCELED$ = RunState.CANCELED$.MODULE$;
            if (!(runState != null ? !runState.equals(cANCELED$) : cANCELED$ != null)) {
                throw new RuntimeException("Pipeline run was canceled.");
            }
        }
        eventSender$1.sendEvent(event);
    }

    public static final /* synthetic */ void $anonfun$startRun$1(PipelineCommand.StartRun cmd$3, GraphRegistrationContext graphElementRegistry$1, PipelinesHandler.TableFilters tableFiltersResult$1, SessionHolder sessionHolder$2, String dataflowGraphId$1, PipelineEventSender eventSender) {
        VolatileObjectRef runFailureEvent = VolatileObjectRef.create((Object)Option$.MODULE$.empty());
        Function1 & Serializable eventCallback = (Function1 & Serializable)event -> {
            PipelinesHandler$.$anonfun$startRun$2(runFailureEvent, eventSender, event);
            return BoxedUnit.UNIT;
        };
        if (cmd$3.getStorage().isEmpty()) {
            throw new IllegalArgumentException("Storage must be specified to start a run.");
        }
        PipelineUpdateContextImpl pipelineUpdateContext = new PipelineUpdateContextImpl(graphElementRegistry$1.toDataflowGraph(), (Function1)eventCallback, tableFiltersResult$1.refresh(), tableFiltersResult$1.fullRefresh(), cmd$3.getStorage());
        sessionHolder$2.cachePipelineExecution(dataflowGraphId$1, (PipelineUpdateContext)pipelineUpdateContext);
        if (cmd$3.getDry()) {
            pipelineUpdateContext.pipelineExecution().dryRunPipeline();
        } else {
            pipelineUpdateContext.pipelineExecution().runPipeline();
        }
        ((Option)runFailureEvent.elem).foreach((Function1 & Serializable)event -> {
            throw (Throwable)event.error().get();
        });
    }

    private static final scala.collection.immutable.Set parseTableNames$1(Seq tableNames, SessionHolder sessionHolder$3, GraphRegistrationContext graphElementRegistry$2) {
        return ((IterableOnceOps)tableNames.map((Function1 & Serializable)name -> GraphIdentifierManager$.MODULE$.parseAndQualifyTableIdentifier(GraphIdentifierManager$.MODULE$.parseTableIdentifier(name, sessionHolder$3.session()), (Option)new Some((Object)graphElementRegistry$2.defaultCatalog()), (Option)new Some((Object)graphElementRegistry$2.defaultDatabase())).identifier())).toSet();
    }

    private PipelinesHandler$() {
    }
}

