/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.analysis.ApplyCharTypePaddingHelper$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.read.streaming.SparkDataStream;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class ApplyCharTypePadding$
extends Rule<LogicalPlan> {
    public static final ApplyCharTypePadding$ MODULE$ = new ApplyCharTypePadding$();

    public LogicalPlan apply(LogicalPlan plan) {
        if (this.conf().charVarcharAsString()) {
            return plan;
        }
        if (this.conf().readSideCharPadding()) {
            LogicalPlan newPlan = plan.resolveOperatorsUpWithNewOutput((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof LogicalRelation) {
                        LogicalRelation logicalRelation = (LogicalRelation)A1;
                        return (B1)ApplyCharTypePaddingHelper$.MODULE$.readSidePadding((LogicalPlan)logicalRelation, (Function0 & Serializable)() -> {
                            Seq x$1 = (Seq)logicalRelation.output().map((Function1 & Serializable)attr -> CharVarcharUtils$.MODULE$.cleanAttrMetadata(attr));
                            BaseRelation x$2 = logicalRelation.copy$default$1();
                            Option<CatalogTable> x$3 = logicalRelation.copy$default$3();
                            boolean x$4 = logicalRelation.copy$default$4();
                            Option<SparkDataStream> x$5 = logicalRelation.copy$default$5();
                            return logicalRelation.copy(x$2, (Seq<AttributeReference>)x$1, x$3, x$4, x$5);
                        });
                    }
                    if (A1 instanceof DataSourceV2Relation) {
                        DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)A1;
                        return (B1)ApplyCharTypePaddingHelper$.MODULE$.readSidePadding((LogicalPlan)dataSourceV2Relation, (Function0 & Serializable)() -> {
                            Seq x$6 = (Seq)dataSourceV2Relation.output().map((Function1 & Serializable)attr -> CharVarcharUtils$.MODULE$.cleanAttrMetadata(attr));
                            Table x$7 = dataSourceV2Relation.copy$default$1();
                            Option x$8 = dataSourceV2Relation.copy$default$3();
                            Option x$9 = dataSourceV2Relation.copy$default$4();
                            CaseInsensitiveStringMap x$10 = dataSourceV2Relation.copy$default$5();
                            return dataSourceV2Relation.copy(x$7, x$6, x$8, x$9, x$10);
                        });
                    }
                    if (A1 instanceof HiveTableRelation) {
                        HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                        return (B1)ApplyCharTypePaddingHelper$.MODULE$.readSidePadding((LogicalPlan)hiveTableRelation, (Function0 & Serializable)() -> {
                            Seq cleanedDataCols = (Seq)hiveTableRelation.dataCols().map((Function1 & Serializable)attr -> CharVarcharUtils$.MODULE$.cleanAttrMetadata(attr));
                            Seq cleanedPartCols = (Seq)hiveTableRelation.partitionCols().map((Function1 & Serializable)attr -> CharVarcharUtils$.MODULE$.cleanAttrMetadata(attr));
                            Seq x$11 = cleanedDataCols;
                            Seq x$12 = cleanedPartCols;
                            CatalogTable x$13 = hiveTableRelation.copy$default$1();
                            Option x$14 = hiveTableRelation.copy$default$4();
                            Option x$15 = hiveTableRelation.copy$default$5();
                            return hiveTableRelation.copy(x$13, x$11, x$12, x$14, x$15);
                        });
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan2 = x1;
                    if (logicalPlan2 instanceof LogicalRelation) {
                        return true;
                    }
                    if (logicalPlan2 instanceof DataSourceV2Relation) {
                        return true;
                    }
                    return logicalPlan2 instanceof HiveTableRelation;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.datasources.LogicalRelation ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.expressions.AttributeReference ), $anonfun$applyOrElse$3(org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation ), $anonfun$applyOrElse$4(org.apache.spark.sql.catalyst.expressions.AttributeReference ), $anonfun$applyOrElse$5(org.apache.spark.sql.catalyst.catalog.HiveTableRelation ), $anonfun$applyOrElse$6(org.apache.spark.sql.catalyst.expressions.AttributeReference ), $anonfun$applyOrElse$7(org.apache.spark.sql.catalyst.expressions.AttributeReference )}, serializedLambda);
                }
            });
            return ApplyCharTypePaddingHelper$.MODULE$.paddingForStringComparison(newPlan, false);
        }
        return ApplyCharTypePaddingHelper$.MODULE$.paddingForStringComparison(plan, !BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.LEGACY_NO_CHAR_PADDING_IN_PREDICATE())));
    }

    private ApplyCharTypePadding$() {
    }
}

