/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public enum AvroCompressionCodec {
    UNCOMPRESSED("null", false),
    DEFLATE("deflate", true),
    SNAPPY("snappy", false),
    BZIP2("bzip2", false),
    XZ("xz", true),
    ZSTANDARD("zstandard", true);

    private final String codecName;
    private final boolean supportCompressionLevel;
    private static final Map<String, String> codecNameMap;

    private AvroCompressionCodec(String codecName, boolean supportCompressionLevel) {
        this.codecName = codecName;
        this.supportCompressionLevel = supportCompressionLevel;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public boolean getSupportCompressionLevel() {
        return this.supportCompressionLevel;
    }

    public String lowerCaseName() {
        return codecNameMap.get(this.name());
    }

    public static AvroCompressionCodec fromString(String s) {
        return AvroCompressionCodec.valueOf(s.toUpperCase(Locale.ROOT));
    }

    static {
        codecNameMap = Arrays.stream(AvroCompressionCodec.values()).collect(Collectors.toMap(codec -> codec.name(), codec -> codec.name().toLowerCase(Locale.ROOT)));
    }
}

