/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.util.IntervalMathUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns `expr1`-`expr2`.", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       1\n  ", since="1.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001\u0002\u0014(\u0001RB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005S\u0001\tE\t\u0015!\u0003N\u0011!\u0019\u0006A!f\u0001\n\u0003!\u0006\u0002C/\u0001\u0005#\u0005\u000b\u0011B+\t\u000by\u0003A\u0011A0\t\u000by\u0003A\u0011\u00013\t\u000b\u001d\u0004A\u0011\t5\t\u000b=\u0004A\u0011\t9\t\u000be\u0004A\u0011\t9\t\u000bi\u0004A\u0011I>\t\r\u0005U\u0001\u0001\"\u0011q\u0011)\t9\u0002\u0001EC\u0002\u0013%\u0011\u0011\u0004\u0005\b\u0003O\u0001A\u0011KA\u0015\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!!\u0010\u0001\t#\ny\u0004C\u0005\u0002J\u0001\t\t\u0011\"\u0001\u0002L!I\u00111\u000b\u0001\u0012\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003W\u0002\u0011\u0013!C\u0001\u0003+B\u0011\"!\u001c\u0001#\u0003%\t!a\u001c\t\u0013\u0005M\u0004!!A\u0005B\u0005U\u0004\"CAC\u0001\u0005\u0005I\u0011AAD\u0011%\tI\tAA\u0001\n\u0003\tY\tC\u0005\u0002\u0012\u0002\t\t\u0011\"\u0011\u0002\u0014\"I\u0011\u0011\u0015\u0001\u0002\u0002\u0013\u0005\u00111\u0015\u0005\n\u0003[\u0003\u0011\u0011!C!\u0003_C\u0011\"a-\u0001\u0003\u0003%\t%!.\b\u0013\u0005ew%!A\t\u0002\u0005mg\u0001\u0003\u0014(\u0003\u0003E\t!!8\t\rysB\u0011AA{\u0011%\t9PHA\u0001\n\u000b\nI\u0010C\u0005\u0002|z\t\t\u0011\"!\u0002~\"I!Q\u0001\u0010\u0012\u0002\u0013\u0005\u0011q\u000e\u0005\n\u0005\u000fq\u0012\u0011!CA\u0005\u0013A\u0011Ba\u0006\u001f#\u0003%\t!a\u001c\t\u0013\tea$!A\u0005\n\tm!\u0001C*vER\u0014\u0018m\u0019;\u000b\u0005!J\u0013aC3yaJ,7o]5p]NT!AK\u0016\u0002\u0011\r\fG/\u00197zgRT!\u0001L\u0017\u0002\u0007M\fHN\u0003\u0002/_\u0005)1\u000f]1sW*\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u001b:\u007fA\u0011agN\u0007\u0002O%\u0011\u0001h\n\u0002\u0011\u0005&t\u0017M]=Be&$\b.\\3uS\u000e\u0004\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002A\u0011:\u0011\u0011I\u0012\b\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tN\na\u0001\u0010:p_Rt\u0014\"\u0001\u001f\n\u0005\u001d[\u0014a\u00029bG.\fw-Z\u0005\u0003\u0013*\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aR\u001e\u0002\t1,g\r^\u000b\u0002\u001bB\u0011aGT\u0005\u0003\u001f\u001e\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u0005AQM^1m\u001b>$W-F\u0001V!\t1\u0016L\u0004\u00027/&\u0011\u0001lJ\u0001\t\u000bZ\fG.T8eK&\u0011!l\u0017\u0002\u0006-\u0006dW/Z\u0005\u00039n\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]\u0006IQM^1m\u001b>$W\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0001\f'm\u0019\t\u0003m\u0001AQaS\u0004A\u00025CQ!U\u0004A\u00025CqaU\u0004\u0011\u0002\u0003\u0007Q\u000bF\u0002aK\u001aDQa\u0013\u0005A\u00025CQ!\u0015\u0005A\u00025\u000b\u0011\"\u001b8qkR$\u0016\u0010]3\u0016\u0003%\u0004\"A[7\u000e\u0003-T!\u0001\\\u0016\u0002\u000bQL\b/Z:\n\u00059\\'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003\u0019\u0019\u00180\u001c2pYV\t\u0011\u000f\u0005\u0002sm:\u00111\u000f\u001e\t\u0003\u0005nJ!!^\u001e\u0002\rA\u0013X\rZ3g\u0013\t9\bP\u0001\u0004TiJLgn\u001a\u0006\u0003kn\nQ\u0002Z3dS6\fG.T3uQ>$\u0017!\u0005:fgVdG\u000fR3dS6\fG\u000eV=qKRAAp`A\u0005\u0003\u001b\t\t\u0002\u0005\u0002k{&\u0011ap\u001b\u0002\f\t\u0016\u001c\u0017.\\1m)f\u0004X\rC\u0004\u0002\u00021\u0001\r!a\u0001\u0002\u0005A\f\u0004c\u0001\u001e\u0002\u0006%\u0019\u0011qA\u001e\u0003\u0007%sG\u000fC\u0004\u0002\f1\u0001\r!a\u0001\u0002\u0005M\f\u0004bBA\b\u0019\u0001\u0007\u00111A\u0001\u0003aJBq!a\u0005\r\u0001\u0004\t\u0019!\u0001\u0002te\u000512-\u00197f]\u0012\f'/\u00138uKJ4\u0018\r\\'fi\"|G-A\u0004ok6,'/[2\u0016\u0005\u0005m\u0001#\u0002!\u0002\u001e\u0005\u0005\u0012bAA\u0010\u0015\n9a*^7fe&\u001c\u0007c\u0001\u001e\u0002$%\u0019\u0011QE\u001e\u0003\u0007\u0005s\u00170\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002\"\u0005-\u0012q\u0006\u0005\b\u0003[y\u0001\u0019AA\u0011\u0003\u0019Ig\u000e];uc!9\u0011\u0011G\bA\u0002\u0005\u0005\u0012AB5oaV$('A\bfq\u0006\u001cG/T1uQ6+G\u000f[8e+\t\t9\u0004\u0005\u0003;\u0003s\t\u0018bAA\u001ew\t1q\n\u001d;j_:\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000b\u0001\f\t%!\u0012\t\r\u0005\r\u0013\u00031\u0001N\u0003\u001dqWm\u001e'fMRDa!a\u0012\u0012\u0001\u0004i\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\bA\u00065\u0013qJA)\u0011\u001dY%\u0003%AA\u00025Cq!\u0015\n\u0011\u0002\u0003\u0007Q\nC\u0004T%A\u0005\t\u0019A+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u000b\u0016\u0004\u001b\u0006e3FAA.!\u0011\ti&a\u001a\u000e\u0005\u0005}#\u0002BA1\u0003G\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u00154(\u0001\u0006b]:|G/\u0019;j_:LA!!\u001b\u0002`\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA9U\r)\u0016\u0011L\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005]\u0004\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0002\u0006!!.\u0019<b\u0013\r9\u00181P\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0007\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\"\u00055\u0005\"CAH1\u0005\u0005\t\u0019AA\u0002\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0013\t\u0007\u0003/\u000bi*!\t\u000e\u0005\u0005e%bAANw\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0015\u0011\u0014\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002&\u0006-\u0006c\u0001\u001e\u0002(&\u0019\u0011\u0011V\u001e\u0003\u000f\t{w\u000e\\3b]\"I\u0011q\u0012\u000e\u0002\u0002\u0003\u0007\u0011\u0011E\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002x\u0005E\u0006\"CAH7\u0005\u0005\t\u0019AA\u0002\u0003\u0019)\u0017/^1mgR!\u0011QUA\\\u0011%\ty\tHA\u0001\u0002\u0004\t\t\u0003K\n\u0001\u0003w\u000b\t-a1\u0002H\u0006%\u0017QZAh\u0003'\f)\u000eE\u00027\u0003{K1!a0(\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!2\u0002[\u0015D\bO]\u0019!?\u001a+fjQ0!Kb\u0004(O\r\u0011.AI+G/\u001e:og\u0002\u0002W\r\u001f9sc\u0001l\u0003-\u001a=qeJ\u0002g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tY-A\u001b\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAI\u0002sLR+O\u0007~\u0003\u0013g\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAi\u0003\u0015\td\u0006\r\u00181\u0003\u00159'o\\;qC\t\t9.\u0001\u0006nCRDwLZ;oGN\f\u0001bU;ciJ\f7\r\u001e\t\u0003my\u0019RAHAp\u0003W\u0004\u0002\"!9\u0002h6kU\u000bY\u0007\u0003\u0003GT1!!:<\u0003\u001d\u0011XO\u001c;j[\u0016LA!!;\u0002d\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u00055\u00181_\u0007\u0003\u0003_TA!!=\u0002\u0000\u0005\u0011\u0011n\\\u0005\u0004\u0013\u0006=HCAAn\u0003!!xn\u0015;sS:<GCAA<\u0003\u0015\t\u0007\u000f\u001d7z)\u001d\u0001\u0017q B\u0001\u0005\u0007AQaS\u0011A\u00025CQ!U\u0011A\u00025CqaU\u0011\u0011\u0002\u0003\u0007Q+A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003\u001d)h.\u00199qYf$BAa\u0003\u0003\u0014A)!(!\u000f\u0003\u000eA1!Ha\u0004N\u001bVK1A!\u0005<\u0005\u0019!V\u000f\u001d7fg!A!QC\u0012\u0002\u0002\u0003\u0007\u0001-A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u000f!\u0011\tIHa\b\n\t\t\u0005\u00121\u0010\u0002\u0007\u001f\nTWm\u0019;")
public class Subtract
extends BinaryArithmetic {
    private Numeric<Object> numeric;
    private final Expression left;
    private final Expression right;
    private final Enumeration.Value evalMode;
    private volatile boolean bitmap$0;

    public static Enumeration.Value $lessinit$greater$default$3() {
        return Subtract$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Enumeration.Value>> unapply(Subtract x$0) {
        return Subtract$.MODULE$.unapply(x$0);
    }

    public static Enumeration.Value apply$default$3() {
        return Subtract$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Enumeration.Value>, Subtract> tupled() {
        return Subtract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Enumeration.Value, Subtract>>> curried() {
        return Subtract$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Enumeration.Value evalMode() {
        return this.evalMode;
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.NumericAndInterval();
    }

    @Override
    public String symbol() {
        return "-";
    }

    @Override
    public String decimalMethod() {
        return "$minus";
    }

    @Override
    public DecimalType resultDecimalType(int p1, int s1, int p2, int s2) {
        int resultScale = package$.MODULE$.max(s1, s2);
        int resultPrecision = package$.MODULE$.max(p1 - s1, p2 - s2) + resultScale + 1;
        if (this.allowPrecisionLoss()) {
            return DecimalType$.MODULE$.adjustPrecisionScale(resultPrecision, resultScale);
        }
        return DecimalType$.MODULE$.bounded(resultPrecision, resultScale);
    }

    @Override
    public String calendarIntervalMethod() {
        if (this.failOnError()) {
            return "subtractExact";
        }
        return "subtract";
    }

    private Numeric<Object> numeric$lzycompute() {
        Subtract subtract = this;
        synchronized (subtract) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        if (!this.bitmap$0) {
            return this.numeric$lzycompute();
        }
        return this.numeric;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        DecimalType decimalType;
        Option option;
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = this.dataType();
        if (dataType2 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType2)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return this.checkDecimalOverflow((Decimal)this.numeric().minus(input1, input2), precision, scale);
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (this.failOnError()) {
                return IntervalUtils$.MODULE$.subtractExact((CalendarInterval)input1, (CalendarInterval)input2);
            }
        }
        if (bl) {
            return IntervalUtils$.MODULE$.subtract((CalendarInterval)input1, (CalendarInterval)input2);
        }
        if (dataType2 instanceof DayTimeIntervalType) {
            return BoxesRunTime.boxToLong((long)IntervalMathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToLong((Object)input1), BoxesRunTime.unboxToLong((Object)input2)));
        }
        if (dataType2 instanceof YearMonthIntervalType) {
            return BoxesRunTime.boxToInteger((int)IntervalMathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToInt((Object)input1), BoxesRunTime.unboxToInt((Object)input2)));
        }
        if (dataType2 instanceof IntegerType && this.failOnError()) {
            return BoxesRunTime.boxToInteger((int)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToInt((Object)input1), BoxesRunTime.unboxToInt((Object)input2), this.getContextOrNull()));
        }
        if (dataType2 instanceof LongType && this.failOnError()) {
            return BoxesRunTime.boxToLong((long)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToLong((Object)input1), BoxesRunTime.unboxToLong((Object)input2), this.getContextOrNull()));
        }
        return this.numeric().minus(input1, input2);
    }

    @Override
    public Option<String> exactMathMethod() {
        return new Some((Object)"subtractExact");
    }

    @Override
    public Subtract withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Subtract copy(Expression left, Expression right, Enumeration.Value evalMode) {
        return new Subtract(left, right, evalMode);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Enumeration.Value copy$default$3() {
        return this.evalMode();
    }

    @Override
    public String productPrefix() {
        return "Subtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.evalMode();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Subtract;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "evalMode";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Subtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        Subtract subtract = (Subtract)x$1;
        Expression expression = this.left();
        Expression expression2 = subtract.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = subtract.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = subtract.evalMode();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!subtract.canEqual(this)) return false;
        return true;
    }

    public Subtract(Expression left, Expression right, Enumeration.Value evalMode) {
        this.left = left;
        this.right = right;
        this.evalMode = evalMode;
    }

    public Subtract(Expression left, Expression right) {
        this(left, right, EvalMode$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

