/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.text;

import java.io.Closeable;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.HadoopFileWholeTextReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.text.TextOptions;
import org.apache.spark.sql.execution.datasources.text.TextOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001\u0002\u0007\u000e\u0001qAQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005B1BQA\u000f\u0001\u0005B1BQa\u000f\u0001\u0005\nqBQ!\u0013\u0001\u0005\n)CQ\u0001\u0014\u0001\u0005B5CQA\u001a\u0001\u0005B\u001dDQa\u001f\u0001\u0005BqDq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u0002f\u0001!I!a\u001a\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\nqA+\u001a=u\r&dWMR8s[\u0006$(B\u0001\b\u0010\u0003\u0011!X\r\u001f;\u000b\u0005A\t\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!AE\n\u0002\u0013\u0015DXmY;uS>t'B\u0001\u000b\u0016\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003-]\tQa\u001d9be.T!\u0001G\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0012aA8sO\u000e\u00011c\u0001\u0001\u001eCA\u0011adH\u0007\u0002\u001f%\u0011\u0001e\u0004\u0002\u0014)\u0016DHOQ1tK\u00124\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003E\u0015j\u0011a\t\u0006\u0003IM\tqa]8ve\u000e,7/\u0003\u0002'G\t\u0011B)\u0019;b'>,(oY3SK\u001eL7\u000f^3s\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\tQ\"A\u0005tQ>\u0014HOT1nKR\tQ\u0006\u0005\u0002/o9\u0011q&\u000e\t\u0003aMj\u0011!\r\u0006\u0003em\ta\u0001\u0010:p_Rt$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a\u0014A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!AN\u001a\u0002\u0011Q|7\u000b\u001e:j]\u001e\fAB^3sS\u001aL8k\u00195f[\u0006$\"!P!\u0011\u0005yzT\"A\u001a\n\u0005\u0001\u001b$\u0001B+oSRDQA\u0011\u0003A\u0002\r\u000baa]2iK6\f\u0007C\u0001#H\u001b\u0005)%B\u0001$\u0014\u0003\u0015!\u0018\u0010]3t\u0013\tAUI\u0001\u0006TiJ,8\r\u001e+za\u0016\f\u0001C^3sS\u001aL(+Z1e'\u000eDW-\\1\u0015\u0005uZ\u0005\"\u0002\"\u0006\u0001\u0004\u0019\u0015aC5t'Bd\u0017\u000e^1cY\u0016$BAT)X9B\u0011ahT\u0005\u0003!N\u0012qAQ8pY\u0016\fg\u000eC\u0003S\r\u0001\u00071+\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002U+6\t1#\u0003\u0002W'\ta1\u000b]1sWN+7o]5p]\")\u0001L\u0002a\u00013\u00069q\u000e\u001d;j_:\u001c\b\u0003\u0002\u0018[[5J!aW\u001d\u0003\u00075\u000b\u0007\u000fC\u0003^\r\u0001\u0007a,\u0001\u0003qCRD\u0007CA0e\u001b\u0005\u0001'BA1c\u0003\t17O\u0003\u0002d/\u00051\u0001.\u00193p_BL!!\u001a1\u0003\tA\u000bG\u000f[\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0003iW2l\u0007c\u0001 j\u0007&\u0011!n\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bI;\u0001\u0019A*\t\u000ba;\u0001\u0019A-\t\u000b9<\u0001\u0019A8\u0002\u000b\u0019LG.Z:\u0011\u0007A,\bP\u0004\u0002rg:\u0011\u0001G]\u0005\u0002i%\u0011AoM\u0001\ba\u0006\u001c7.Y4f\u0013\t1xOA\u0002TKFT!\u0001^\u001a\u0011\u0005}K\u0018B\u0001>a\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\n{\u0006\u0005\u00111AA\n\u0003+\u0001\"A\b@\n\u0005}|!aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\b\"\u0002*\t\u0001\u0004\u0019\u0006bBA\u0003\u0011\u0001\u0007\u0011qA\u0001\u0004U>\u0014\u0007\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055!-A\u0005nCB\u0014X\rZ;dK&!\u0011\u0011CA\u0006\u0005\rQuN\u0019\u0005\u00061\"\u0001\r!\u0017\u0005\u0007\u0003/A\u0001\u0019A\"\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017-A\u0006ck&dGMU3bI\u0016\u0014H\u0003EA\u000f\u0003w\ti$a\u0010\u0002D\u0005\u001d\u00131KA+!\u001dq\u0014qDA\u0012\u0003SI1!!\t4\u0005%1UO\\2uS>t\u0017\u0007E\u0002\u001f\u0003KI1!a\n\u0010\u0005=\u0001\u0016M\u001d;ji&|g.\u001a3GS2,\u0007#\u00029\u0002,\u0005=\u0012bAA\u0017o\nA\u0011\n^3sCR|'\u000f\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)dE\u0001\tG\u0006$\u0018\r\\=ti&!\u0011\u0011HA\u001a\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000bIK\u0001\u0019A*\t\r\u0005]\u0011\u00021\u0001D\u0011\u0019\t\t%\u0003a\u0001\u0007\u0006y\u0001/\u0019:uSRLwN\\*dQ\u0016l\u0017\r\u0003\u0004\u0002F%\u0001\raQ\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0011\u001d\tI%\u0003a\u0001\u0003\u0017\nqAZ5mi\u0016\u00148\u000f\u0005\u0003qk\u00065\u0003c\u0001\u0012\u0002P%\u0019\u0011\u0011K\u0012\u0003\r\u0019KG\u000e^3s\u0011\u0015A\u0016\u00021\u0001Z\u0011\u001d\t9&\u0003a\u0001\u00033\n!\u0002[1e_>\u00048i\u001c8g!\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0E\u0006!1m\u001c8g\u0013\u0011\t\u0019'!\u0018\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003=\u0011X-\u00193U_Vs7/\u00194f\u001b\u0016lG\u0003CA5\u0003s\n\u0019*!&\u0011\u000fy\ny\"a\t\u0002lA)\u0001/a\u000b\u0002nA!\u0011qNA;\u001b\t\t\tH\u0003\u0003\u0002t\u0005M\u0012aC3yaJ,7o]5p]NLA!a\u001e\u0002r\tIQK\\:bM\u0016\u0014vn\u001e\u0005\b\u0003?R\u0001\u0019AA>!\u0019\ti(a!\u0002\b6\u0011\u0011q\u0010\u0006\u0004\u0003\u0003+\u0012!\u00032s_\u0006$7-Y:u\u0013\u0011\t))a \u0003\u0013\t\u0013x.\u00193dCN$\b\u0003BAE\u0003\u001fk!!a#\u000b\u0007\u00055U#\u0001\u0003vi&d\u0017\u0002BAI\u0003\u0017\u0013\u0011dU3sS\u0006d\u0017N_1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"1\u0011Q\t\u0006A\u0002\rCq!a&\u000b\u0001\u0004\tI*A\u0006uKb$x\n\u001d;j_:\u001c\bc\u0001\u0016\u0002\u001c&\u0019\u0011QT\u0007\u0003\u0017Q+\u0007\u0010^(qi&|gn]\u0001\u0010gV\u0004\bo\u001c:u\t\u0006$\u0018\rV=qKR\u0019a*a)\t\u000f\u0005\u00156\u00021\u0001\u0002(\u0006AA-\u0019;b)f\u0004X\rE\u0002E\u0003SK1!a+F\u0005!!\u0015\r^1UsB,\u0007")
public class TextFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "text";
    }

    public String toString() {
        return "Text";
    }

    private void verifySchema(StructType schema) {
        if (schema.size() != 1) {
            throw QueryCompilationErrors$.MODULE$.textDataSourceWithMultiColumnsError(schema);
        }
    }

    private void verifyReadSchema(StructType schema) {
        if (schema.size() > 1) {
            throw QueryCompilationErrors$.MODULE$.textDataSourceWithMultiColumnsError(schema);
        }
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        TextOptions textOptions = new TextOptions(options);
        return super.isSplitable(sparkSession, options, path) && !textOptions.wholeText();
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)new StructType().add("value", (DataType)StringType$.MODULE$));
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema);
        TextOptions textOptions = new TextOptions(options);
        Configuration conf = job.getConfiguration();
        textOptions.compressionCodec().foreach((Function1 & Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, textOptions){
            private final TextOptions textOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new TextOutputWriter(path, dataSchema, this.textOptions$1.lineSeparatorInWrite(), context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return ".txt" + CodecStreams$.MODULE$.getCompressionExtension((JobContext)context);
            }
            {
                this.textOptions$1 = textOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        this.verifyReadSchema(requiredSchema);
        TextOptions textOptions = new TextOptions(options);
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return this.readToUnsafeMem((Broadcast<SerializableConfiguration>)broadcastedHadoopConf, requiredSchema, textOptions);
    }

    private Function1<PartitionedFile, Iterator<UnsafeRow>> readToUnsafeMem(Broadcast<SerializableConfiguration> conf, StructType requiredSchema, TextOptions textOptions) {
        return (Function1 & Serializable)file -> {
            Configuration confValue = ((SerializableConfiguration)conf.value()).value();
            Iterator reader = (Iterator)Utils$.MODULE$.createResourceUninterruptiblyIfInTaskThread((Function0 & Serializable)() -> {
                if (!textOptions.wholeText()) {
                    return new HadoopFileLinesReader((PartitionedFile)file, textOptions.lineSeparatorInRead(), confValue);
                }
                return new HadoopFileWholeTextReader((PartitionedFile)file, confValue);
            });
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)x$1 -> x$1.addTaskCompletionListener((Function1 & Serializable)x$2 -> {
                TextFileFormat.$anonfun$readToUnsafeMem$4(reader, x$2);
                return BoxedUnit.UNIT;
            }));
            if (requiredSchema.isEmpty()) {
                UnsafeRow emptyUnsafeRow = new UnsafeRow(0);
                return reader.map((Function1 & Serializable)x$3 -> emptyUnsafeRow);
            }
            UnsafeRowWriter unsafeRowWriter = new UnsafeRowWriter(1);
            return reader.map((Function1 & Serializable)line -> {
                unsafeRowWriter.reset();
                unsafeRowWriter.write(0, line.getBytes(), 0, line.getLength());
                return unsafeRowWriter.getRow();
            });
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        return dataType instanceof StringType;
    }

    public static final /* synthetic */ void $anonfun$readToUnsafeMem$4(Iterator reader$1, TaskContext x$2) {
        ((Closeable)reader$1).close();
    }
}

