/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.internal;

import coursierapi.shaded.coursier.cache.ArtifactError;
import coursierapi.shaded.coursier.cache.ArtifactError$NotFound$;
import coursierapi.shaded.coursier.cache.CacheLocks$;
import coursierapi.shaded.coursier.cache.CacheLogger;
import coursierapi.shaded.coursier.cache.CachePolicy;
import coursierapi.shaded.coursier.cache.CacheUrl$;
import coursierapi.shaded.coursier.cache.ConnectionBuilder$;
import coursierapi.shaded.coursier.cache.internal.Downloader;
import coursierapi.shaded.coursier.cache.internal.Downloader$UnknownProtocol$;
import coursierapi.shaded.coursier.core.Authentication;
import coursierapi.shaded.coursier.credentials.DirectCredentials;
import coursierapi.shaded.coursier.util.Artifact;
import coursierapi.shaded.coursier.util.Sync;
import coursierapi.shaded.scala.Array$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.IterableOnceOps;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.concurrent.duration.Duration;
import coursierapi.shaded.scala.package$;
import coursierapi.shaded.scala.reflect.ClassTag$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.ScalaRunTime$;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Right;
import coursierapi.shaded.scala.util.control.NonFatal$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.time.Clock;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

public final class Downloader$
implements Serializable {
    public static final Downloader$ MODULE$ = new Downloader$();
    private static final Seq<String> coursier$cache$internal$Downloader$$checksumHeader = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MD5", "SHA1", "SHA256"}));

    public Seq<String> coursier$cache$internal$Downloader$$checksumHeader() {
        return coursier$cache$internal$Downloader$$checksumHeader;
    }

    public void coursier$cache$internal$Downloader$$readFullyTo(InputStream in, OutputStream out, CacheLogger logger, String url, long alreadyDownloaded, int bufferSize) {
        byte[] b = (byte[])Array$.MODULE$.fill(bufferSize, () -> 0, ClassTag$.MODULE$.Byte());
        this.helper$1(alreadyDownloaded, in, b, out, logger, url);
    }

    public <T> Either<ArtifactError, T> coursier$cache$internal$Downloader$$downloading(String url, File file, int sslRetry, Function0<Either<ArtifactError, T>> f, Function0<Option<Either<ArtifactError, T>>> ifLocked) {
        return this.helper$2(sslRetry, url, f, ifLocked);
    }

    public Either<ArtifactError, Option<Object>> coursier$cache$internal$Downloader$$contentLength(String url, Option<Authentication> authentication, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> credentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, CacheLogger logger, Option<Object> maxRedirectionsOpt) {
        Left<ArtifactError, Option<Object>> left;
        block10: {
            URLConnection conn = null;
            try {
                Either either;
                URLConnection uRLConnection = conn = ConnectionBuilder$.MODULE$.apply(url).withAuthentication(authentication).withFollowHttpToHttpsRedirections(followHttpToHttpsRedirections).withFollowHttpsToHttpRedirections(followHttpsToHttpRedirections).withAutoCredentials(credentials).withSslSocketFactoryOpt(sslSocketFactoryOpt).withHostnameVerifierOpt(hostnameVerifierOpt).withMethod("HEAD").withMaxRedirectionsOpt(maxRedirectionsOpt).connection();
                if (uRLConnection instanceof HttpURLConnection) {
                    Right right;
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    logger.gettingLength(url);
                    boolean success = false;
                    try {
                        Option<Object> len = new Some<Long>(BoxesRunTime.boxToLong(httpURLConnection.getContentLengthLong())).filter(x$26 -> x$26 >= 0L);
                        success = true;
                        logger.gettingLengthResult(url, len);
                        right = package$.MODULE$.Right().apply(len);
                    }
                    finally {
                        if (!success) {
                            logger.gettingLengthResult(url, None$.MODULE$);
                        }
                    }
                    either = right;
                } else {
                    either = package$.MODULE$.Left().apply(new ArtifactError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(uRLConnection).append(" (").append(url).append(")").toString(), None$.MODULE$));
                }
                left = either;
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    CacheUrl$.MODULE$.closeConn(conn);
                }
                throw throwable;
            }
            if (conn == null) break block10;
            CacheUrl$.MODULE$.closeConn(conn);
        }
        return left;
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, classLoaders, clock, S);
    }

    private final void helper$1(long count, InputStream in$1, byte[] b$1, OutputStream out$1, CacheLogger logger$2, String url$9) {
        int read;
        while ((read = in$1.read(b$1)) >= 0) {
            out$1.write(b$1, 0, read);
            out$1.flush();
            logger$2.downloadProgress(url$9, count + (long)read);
            count += (long)read;
        }
    }

    private final Either helper$2(int retry, String url$10, Function0 f$1, Function0 ifLocked$1) {
        Either res;
        None$ none$;
        block10: {
            while (true) {
                None$ resOpt;
                None$ none$2;
                try {
                    Option res0 = CacheLocks$.MODULE$.withUrlLock(url$10, (Function0<Either> & Serializable)() -> {
                        Left left;
                        try {
                            left = (Left)f$1.apply();
                        }
                        catch (Throwable throwable) {
                            FileNotFoundException fileNotFoundException;
                            Throwable throwable2 = throwable;
                            if (!(throwable2 instanceof FileNotFoundException) || (fileNotFoundException = (FileNotFoundException)throwable2).getMessage() == null) {
                                throw throwable;
                            }
                            Left left2 = package$.MODULE$.Left().apply(new ArtifactError.NotFound(fileNotFoundException.getMessage(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
                            left = left2;
                        }
                        return left;
                    });
                    none$2 = res0.orElse(ifLocked$1);
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Option<Tuple2<MalformedURLException, String>> option2;
                    Option option3;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SSLException && retry >= 1) {
                        option3 = None$.MODULE$;
                    } else if (throwable2 != null && !(option2 = Downloader$UnknownProtocol$.MODULE$.unapply(throwable2)).isEmpty()) {
                        MalformedURLException e = option2.get()._1();
                        String msg0 = option2.get()._2();
                        String docUrl = "https://get-coursier.io/docs/extra.html#extra-protocols";
                        String msg = ((IterableOnceOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(30).append("Caught ").append(e.getClass().getName()).append(" (").append(msg0).append(") while downloading ").append(url$10).append(".").toString(), new StringBuilder(47).append("Visit ").append(docUrl).append(" to learn how to handle custom protocols.").toString()}))).mkString(" ");
                        ArtifactError.DownloadError ex = new ArtifactError.DownloadError(msg, new Some<Throwable>(e));
                        option3 = new Some(package$.MODULE$.Left().apply(ex));
                    } else if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = option.get();
                        ArtifactError.DownloadError ex = new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(e.getClass().getName()).append(Option$.MODULE$.apply(e.getMessage()).fold((Function0<String> & Serializable)() -> "", (Function1<String, String> & Serializable)x$25 -> new StringBuilder(3).append(" (").append((String)x$25).append(")").toString())).append(" while downloading ").append(url$10).toString(), new Some<Throwable>(e));
                        if (Boolean.getBoolean("coursierapi.shaded.coursier.cache.throw-exceptions")) {
                            throw ex;
                        }
                        option3 = new Some(package$.MODULE$.Left().apply(ex));
                    } else {
                        throw throwable;
                    }
                    none$2 = option3;
                }
                none$ = resOpt = none$2;
                if (none$ instanceof Some) break block10;
                if (!None$.MODULE$.equals(none$)) break;
                --retry;
            }
            throw new MatchError(none$);
        }
        Some some = (Some)((Object)none$);
        Either either = res = (Either)some.value();
        return either;
    }

    private Downloader$() {
    }
}

