/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.CheckpointReader$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.util.ShutdownHookManager$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.StringContext;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public final class StreamingContext$
implements Logging {
    public static final StreamingContext$ MODULE$ = new StreamingContext$();
    private static final Object org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK;
    private static final int org$apache$spark$streaming$StreamingContext$$SHUTDOWN_HOOK_PRIORITY;
    private static final AtomicReference<StreamingContext> activeContext;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK = new Object();
        org$apache$spark$streaming$StreamingContext$$SHUTDOWN_HOOK_PRIORITY = ShutdownHookManager$.MODULE$.SPARK_CONTEXT_SHUTDOWN_PRIORITY() + 1;
        activeContext = new AtomicReference<Object>(null);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String $lessinit$greater$default$4() {
        return null;
    }

    public Seq<String> $lessinit$greater$default$5() {
        return Nil$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$6() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Object org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK() {
        return org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK;
    }

    public int org$apache$spark$streaming$StreamingContext$$SHUTDOWN_HOOK_PRIORITY() {
        return org$apache$spark$streaming$StreamingContext$$SHUTDOWN_HOOK_PRIORITY;
    }

    private AtomicReference<StreamingContext> activeContext() {
        return activeContext;
    }

    public void org$apache$spark$streaming$StreamingContext$$assertNoOtherContextIsActive() {
        Object object = this.org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK();
        synchronized (object) {
            if (this.activeContext().get() != null) {
                throw new IllegalStateException("Only one StreamingContext may be started in this JVM. Currently running StreamingContext was started at" + this.activeContext().get().getStartSite().longForm());
            }
        }
    }

    public void org$apache$spark$streaming$StreamingContext$$setActiveContext(StreamingContext ssc) {
        Object object = this.org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK();
        synchronized (object) {
            this.activeContext().set(ssc);
        }
    }

    public Option<StreamingContext> getActive() {
        Option option;
        Object object = this.org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK();
        synchronized (object) {
            option = Option$.MODULE$.apply((Object)this.activeContext().get());
        }
        return option;
    }

    public StreamingContext getActiveOrCreate(Function0<StreamingContext> creatingFunc) {
        StreamingContext streamingContext;
        Object object = this.org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK();
        synchronized (object) {
            streamingContext = (StreamingContext)this.getActive().getOrElse(creatingFunc);
        }
        return streamingContext;
    }

    public StreamingContext getActiveOrCreate(String checkpointPath, Function0<StreamingContext> creatingFunc, Configuration hadoopConf, boolean createOnError) {
        StreamingContext streamingContext;
        Object object = this.org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK();
        synchronized (object) {
            streamingContext = (StreamingContext)this.getActive().getOrElse((Function0 & Serializable)() -> MODULE$.getOrCreate(checkpointPath, creatingFunc, hadoopConf, createOnError));
        }
        return streamingContext;
    }

    public Configuration getActiveOrCreate$default$3() {
        return SparkHadoopUtil$.MODULE$.get().conf();
    }

    public boolean getActiveOrCreate$default$4() {
        return false;
    }

    public StreamingContext getOrCreate(String checkpointPath, Function0<StreamingContext> creatingFunc, Configuration hadoopConf, boolean createOnError) {
        Option<Checkpoint> checkpointOption = CheckpointReader$.MODULE$.read(checkpointPath, new SparkConf(), hadoopConf, createOnError);
        return (StreamingContext)checkpointOption.map((Function1 & Serializable)x$7 -> new StreamingContext(null, (Checkpoint)x$7, null)).getOrElse(creatingFunc);
    }

    public Configuration getOrCreate$default$3() {
        return SparkHadoopUtil$.MODULE$.get().conf();
    }

    public boolean getOrCreate$default$4() {
        return false;
    }

    public Option<String> jarOfClass(Class<?> cls) {
        return SparkContext$.MODULE$.jarOfClass(cls);
    }

    public SparkContext createNewSparkContext(SparkConf conf) {
        return new SparkContext(conf);
    }

    public SparkContext createNewSparkContext(String master, String appName, String sparkHome, Seq<String> jars, Map<String, String> environment) {
        SparkConf conf = SparkContext$.MODULE$.updatedConf(new SparkConf(), master, appName, sparkHome, jars, environment);
        return new SparkContext(conf);
    }

    public <T> String rddToFileName(String prefix, String suffix, Time time) {
        Object result;
        block1: {
            result = Long.toString(time.milliseconds());
            if (prefix != null && prefix.length() > 0) {
                result = prefix + "-" + (String)result;
            }
            if (suffix == null || suffix.length() <= 0) break block1;
            result = (String)result + "." + suffix;
        }
        return result;
    }

    private StreamingContext$() {
    }
}

