/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationRequestPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class ReservationRequestsPBImpl
extends ReservationRequests {
    YarnProtos.ReservationRequestsProto proto = YarnProtos.ReservationRequestsProto.getDefaultInstance();
    YarnProtos.ReservationRequestsProto.Builder builder = null;
    boolean viaProto = false;
    public List<ReservationRequest> reservationRequests;

    public ReservationRequestsPBImpl() {
        this.builder = YarnProtos.ReservationRequestsProto.newBuilder();
    }

    public ReservationRequestsPBImpl(YarnProtos.ReservationRequestsProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ReservationRequestsProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.reservationRequests != null) {
            this.addReservationResourcesToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ReservationRequestsProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public List<ReservationRequest> getReservationResources() {
        this.initReservationRequestsList();
        return this.reservationRequests;
    }

    @Override
    public void setReservationResources(List<ReservationRequest> resources) {
        if (resources == null) {
            this.builder.clearReservationResources();
            return;
        }
        this.reservationRequests = resources;
    }

    @Override
    public ReservationRequestInterpreter getInterpreter() {
        YarnProtos.ReservationRequestsProtoOrBuilder p;
        YarnProtos.ReservationRequestsProtoOrBuilder reservationRequestsProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasInterpreter()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getInterpreter());
    }

    @Override
    public void setInterpreter(ReservationRequestInterpreter interpreter) {
        this.maybeInitBuilder();
        if (interpreter == null) {
            this.builder.clearInterpreter();
            return;
        }
        this.builder.setInterpreter(this.convertToProtoFormat(interpreter));
    }

    private void initReservationRequestsList() {
        if (this.reservationRequests != null) {
            return;
        }
        YarnProtos.ReservationRequestsProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ReservationRequestProto> resourceProtos = p.getReservationResourcesList();
        this.reservationRequests = new ArrayList<ReservationRequest>();
        for (YarnProtos.ReservationRequestProto r : resourceProtos) {
            this.reservationRequests.add(this.convertFromProtoFormat(r));
        }
    }

    private void addReservationResourcesToProto() {
        this.maybeInitBuilder();
        this.builder.clearReservationResources();
        if (this.reservationRequests == null) {
            return;
        }
        Iterable<YarnProtos.ReservationRequestProto> iterable = new Iterable<YarnProtos.ReservationRequestProto>(){

            @Override
            public Iterator<YarnProtos.ReservationRequestProto> iterator() {
                return new Iterator<YarnProtos.ReservationRequestProto>(){
                    Iterator<ReservationRequest> iter;
                    {
                        this.iter = ReservationRequestsPBImpl.this.reservationRequests.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ReservationRequestProto next() {
                        return ReservationRequestsPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllReservationResources((Iterable<? extends YarnProtos.ReservationRequestProto>)iterable);
    }

    private YarnProtos.ReservationRequestProto convertToProtoFormat(ReservationRequest r) {
        return ((ReservationRequestPBImpl)r).getProto();
    }

    private ReservationRequestPBImpl convertFromProtoFormat(YarnProtos.ReservationRequestProto r) {
        return new ReservationRequestPBImpl(r);
    }

    private YarnProtos.ReservationRequestInterpreterProto convertToProtoFormat(ReservationRequestInterpreter r) {
        return ProtoUtils.convertToProtoFormat(r);
    }

    private ReservationRequestInterpreter convertFromProtoFormat(YarnProtos.ReservationRequestInterpreterProto r) {
        return ProtoUtils.convertFromProtoFormat(r);
    }

    public String toString() {
        return "{Reservation Resources: " + this.getReservationResources() + ", Reservation Type: " + (Object)((Object)this.getInterpreter()) + "}";
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ReservationRequestsPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }
}

