/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import java.util.Arrays;
import java.util.Date;

public final class LongUtils {
    private static final int RADIX = 10;

    private LongUtils() {
    }

    public static long safeAdd(long a, long b) {
        long result;
        if ((a ^ b) < 0L | (a ^ (result = a + b)) >= 0L) {
            return result;
        }
        return Long.MAX_VALUE;
    }

    public static long calculateExpirationTime(long expiration) {
        return LongUtils.safeAdd(expiration, new Date().getTime());
    }

    public static Long tryParse(String string) {
        int digit;
        int index;
        if (string == null || string.isEmpty()) {
            return null;
        }
        boolean negative = string.charAt(0) == '-';
        int n = index = negative ? 1 : 0;
        if (index == string.length()) {
            return null;
        }
        if ((digit = AsciiDigits.digit(string.charAt(index++))) < 0 || digit >= 10) {
            return null;
        }
        long accum = -digit;
        long cap = -922337203685477580L;
        while (index < string.length()) {
            if ((digit = AsciiDigits.digit(string.charAt(index++))) < 0 || digit >= 10 || accum < cap) {
                return null;
            }
            if ((accum *= 10L) < Long.MIN_VALUE + (long)digit) {
                return null;
            }
            accum -= (long)digit;
        }
        if (negative) {
            return accum;
        }
        if (accum == Long.MIN_VALUE) {
            return null;
        }
        return -accum;
    }

    private static final class AsciiDigits {
        private static final byte[] asciiDigits;

        private AsciiDigits() {
        }

        static int digit(char c) {
            return c < '\u0080' ? asciiDigits[c] : -1;
        }

        static {
            int i;
            byte[] result = new byte[128];
            Arrays.fill(result, (byte)-1);
            for (i = 0; i < 10; ++i) {
                result[48 + i] = (byte)i;
            }
            for (i = 0; i < 26; ++i) {
                result[65 + i] = (byte)(10 + i);
                result[97 + i] = (byte)(10 + i);
            }
            asciiDigits = result;
        }
    }
}

