/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.AiProxyApiKeyMapper;
import org.apache.shenyu.admin.model.entity.ProxyApiKeyDO;
import org.apache.shenyu.admin.service.AiProxyConnectionService;
import org.apache.shenyu.admin.service.support.AiProxyRealKeyResolver;
import org.apache.shenyu.common.dto.ProxyApiKeyData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class AiProxyConnectionServiceImpl
implements AiProxyConnectionService {
    private static final Logger LOG = LoggerFactory.getLogger(AiProxyConnectionServiceImpl.class);
    private final AiProxyRealKeyResolver aiProxyRealKeyResolver;
    private final AiProxyApiKeyMapper aiProxyApiKeyMapper;
    private final ApplicationEventPublisher eventPublisher;

    public AiProxyConnectionServiceImpl(AiProxyRealKeyResolver aiProxyRealKeyResolver, AiProxyApiKeyMapper aiProxyApiKeyMapper, ApplicationEventPublisher eventPublisher) {
        this.aiProxyRealKeyResolver = aiProxyRealKeyResolver;
        this.aiProxyApiKeyMapper = aiProxyApiKeyMapper;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void refreshApiKeysBySelectorId(String selectorId) {
        this.aiProxyRealKeyResolver.invalidate(selectorId);
        LOG.info("[AiProxyConnectionService] invalidated real-key resolver for selectorId={}", (Object)selectorId);
        List<ProxyApiKeyDO> keys = this.aiProxyApiKeyMapper.selectBySelectorId(selectorId);
        if (CollectionUtils.isEmpty(keys)) {
            LOG.info("[AiProxyConnectionService] no api keys found for selectorId={}, skipping refresh", (Object)selectorId);
            return;
        }
        List apiKeyDataList = keys.stream().map(this::buildData).collect(Collectors.toList());
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.AI_PROXY_API_KEY, DataEventTypeEnum.UPDATE, apiKeyDataList));
        LOG.info("[AiProxyConnectionService] published UPDATE event for {} api keys under selectorId={}", (Object)apiKeyDataList.size(), (Object)selectorId);
    }

    private ProxyApiKeyData buildData(ProxyApiKeyDO apiKeyDO) {
        String realApiKey = this.aiProxyRealKeyResolver.resolveRealKey(apiKeyDO.getSelectorId()).orElse(null);
        ProxyApiKeyData data = new ProxyApiKeyData();
        data.setSelectorId(apiKeyDO.getSelectorId());
        data.setNamespaceId(apiKeyDO.getNamespaceId());
        data.setProxyApiKey(apiKeyDO.getProxyApiKey());
        data.setRealApiKey(realApiKey);
        data.setEnabled(Boolean.valueOf(Boolean.TRUE.equals(apiKeyDO.getEnabled())));
        data.setDescription(apiKeyDO.getDescription());
        return data;
    }
}

