/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.DsgCollectionImpl;
import ucar.nc2.ft.point.PointIteratorFiltered;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonRect;

public abstract class PointCollectionImpl
extends DsgCollectionImpl
implements PointFeatureCollection {
    protected PointFeatureIterator localIterator;

    protected PointCollectionImpl(String name, CalendarDateUnit timeUnit, String altUnits) {
        super(name, timeUnit, altUnits);
    }

    @Override
    @Nonnull
    public FeatureType getCollectionFeatureType() {
        return FeatureType.POINT;
    }

    @Override
    public PointFeatureCollection subset(LatLonRect boundingBox, CalendarDateRange dateRange) {
        return new PointCollectionSubset(this, boundingBox, dateRange);
    }

    @Override
    public Iterator<PointFeature> iterator() {
        try {
            return this.getPointFeatureIterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public void finish() {
        if (this.localIterator != null) {
            this.localIterator.close();
        }
    }

    @Override
    public PointFeature next() {
        return this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getPointFeatureIterator();
    }

    protected static class PointCollectionSubset
    extends PointCollectionImpl {
        protected PointCollectionImpl from;
        protected LatLonRect filter_bb;
        protected CalendarDateRange filter_date;

        public PointCollectionSubset(PointCollectionImpl from, LatLonRect filter_bb, CalendarDateRange filter_date) {
            super(from.name, from.getTimeUnit(), from.getAltUnits());
            this.from = from;
            this.filter_bb = filter_bb;
            this.filter_date = filter_date;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator() throws IOException {
            return new PointIteratorFiltered(this.from.getPointFeatureIterator(), this.filter_bb, this.filter_date);
        }
    }
}

