/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jiffle.runtime;

import it.geosolutions.jaiext.jiffle.runtime.AffineCoordinateTransform;
import it.geosolutions.jaiext.jiffle.runtime.CoordinateTransform;
import it.geosolutions.jaiext.jiffle.runtime.IdentityCoordinateTransform;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class CoordinateTransforms {
    public static CoordinateTransform identity() {
        return IdentityCoordinateTransform.INSTANCE;
    }

    public static CoordinateTransform scale(double xscale, double yscale) {
        return new AffineCoordinateTransform(AffineTransform.getScaleInstance(xscale, yscale));
    }

    public static CoordinateTransform translation(double dx, double dy) {
        return new AffineCoordinateTransform(AffineTransform.getTranslateInstance(dx, dy));
    }

    public static CoordinateTransform unitBounds(Rectangle imageBounds) {
        if (imageBounds == null || imageBounds.isEmpty()) {
            throw new IllegalArgumentException("imageBounds must not be null or empty");
        }
        return CoordinateTransforms.getTransform(new Rectangle(0, 0, 1, 1), imageBounds);
    }

    public static CoordinateTransform getTransform(Rectangle2D worldBounds, Rectangle imageBounds) {
        return CoordinateTransforms.getTransform(worldBounds, imageBounds, false, false);
    }

    public static CoordinateTransform getTransform(Rectangle2D worldBounds, Rectangle imageBounds, boolean reverseX, boolean reverseY) {
        double yoff;
        double xoff;
        if (worldBounds == null || worldBounds.isEmpty()) {
            throw new IllegalArgumentException("worldBounds must not be null or empty");
        }
        if (imageBounds == null || imageBounds.isEmpty()) {
            throw new IllegalArgumentException("imageBounds must not be null or empty");
        }
        double xscale = (imageBounds.getMaxX() - imageBounds.getMinX()) / (worldBounds.getMaxX() - worldBounds.getMinX());
        if (reverseX) {
            xscale = -xscale;
            xoff = imageBounds.getMinX() - xscale * worldBounds.getMaxX();
        } else {
            xoff = imageBounds.getMinX() - xscale * worldBounds.getMinX();
        }
        double yscale = (imageBounds.getMaxY() - imageBounds.getMinY()) / (worldBounds.getMaxY() - worldBounds.getMinY());
        if (reverseY) {
            yscale = -yscale;
            yoff = imageBounds.getMinY() - yscale * worldBounds.getMaxY();
        } else {
            yoff = imageBounds.getMinY() - yscale * worldBounds.getMinY();
        }
        return new AffineCoordinateTransform(new AffineTransform(xscale, 0.0, 0.0, yscale, xoff, yoff));
    }
}

