/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.ncml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import thredds.inventory.MFile;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.internal.ncml.AggDataset;
import ucar.nc2.internal.ncml.Aggregation;
import ucar.nc2.internal.ncml.AggregationOuter;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateFromString;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileFactory;

class AggDatasetOuter
extends AggDataset {
    private final AggregationOuter aggregationOuter;
    @Nullable
    final String coordValue;
    final Date coordValueDate;
    final boolean isStringValued;
    int ncoord;
    int aggStart;
    int aggEnd;

    AggDatasetOuter(AggregationOuter aggregationOuter, String cacheName, String location, String id, String ncoordS, String coordValueS, EnumSet<NetcdfDataset.Enhance> enhance, FileFactory reader) {
        super(cacheName, location, id, enhance, reader, aggregationOuter.spiObject, aggregationOuter.ncmlElem);
        this.aggregationOuter = aggregationOuter;
        if (aggregationOuter.type == Aggregation.Type.joinNew || aggregationOuter.type == Aggregation.Type.joinExistingOne) {
            this.ncoord = 1;
        }
        if (ncoordS != null) {
            try {
                this.ncoord = Integer.parseInt(ncoordS);
            }
            catch (NumberFormatException e) {
                Aggregation.logger.error("bad ncoord attribute on dataset=" + location);
            }
        }
        boolean isString = false;
        if (aggregationOuter.type == Aggregation.Type.joinNew || aggregationOuter.type == Aggregation.Type.joinExistingOne || aggregationOuter.type == Aggregation.Type.forecastModelRunCollection) {
            if (coordValueS == null) {
                coordValueS = this.extractCoordNameFromFilename(this.getLocation());
                isString = true;
            } else {
                try {
                    Double.parseDouble(coordValueS);
                }
                catch (NumberFormatException e) {
                    isString = true;
                }
            }
        }
        if (aggregationOuter.type == Aggregation.Type.joinExisting && coordValueS != null) {
            StringTokenizer stoker = new StringTokenizer(coordValueS, " ,");
            this.ncoord = stoker.countTokens();
        }
        this.isStringValued = isString;
        this.coordValue = coordValueS;
        this.coordValueDate = null;
    }

    private String extractCoordNameFromFilename(String loc) {
        int pos = loc.lastIndexOf(47);
        String result = pos < 0 ? loc : loc.substring(pos + 1);
        pos = result.lastIndexOf(35);
        if (pos > 0) {
            result = result.substring(0, pos);
        }
        return result;
    }

    AggDatasetOuter(AggregationOuter aggregationOuter, MFile cd2) {
        super(cd2, aggregationOuter.spiObject, aggregationOuter.ncmlElem);
        this.aggregationOuter = aggregationOuter;
        if (aggregationOuter.type == Aggregation.Type.joinNew || aggregationOuter.type == Aggregation.Type.joinExistingOne) {
            this.ncoord = 1;
        }
        String coordValueS = null;
        if (aggregationOuter.type == Aggregation.Type.joinNew || aggregationOuter.type == Aggregation.Type.joinExistingOne || aggregationOuter.type == Aggregation.Type.forecastModelRunCollection) {
            coordValueS = this.extractCoordNameFromFilename(this.getLocation());
            this.isStringValued = true;
        } else {
            this.isStringValued = false;
        }
        if (null != aggregationOuter.dateFormatMark) {
            String filename = cd2.getName();
            this.coordValueDate = DateFromString.getDateUsingDemarkatedCount(filename, aggregationOuter.dateFormatMark, '#');
            coordValueS = new DateFormatter().toDateTimeStringISO(this.coordValueDate);
            if (Aggregation.debugDateParse) {
                System.out.println("  adding " + cd2.getPath() + " date= " + coordValueS);
            }
        } else {
            this.coordValueDate = null;
            if (Aggregation.debugDateParse) {
                System.out.println("  adding " + cd2.getPath());
            }
        }
        if (coordValueS == null && aggregationOuter.type == Aggregation.Type.joinNew) {
            coordValueS = cd2.getName();
        }
        this.coordValue = coordValueS;
    }

    public String getCoordValueString() {
        return this.coordValue;
    }

    public Date getCoordValueDate() {
        return this.coordValueDate;
    }

    @Override
    public void show(Formatter f) {
        f.format("   %s", this.getLocation());
        if (this.coordValue != null) {
            f.format(" coordValue='%s'", this.coordValue);
        }
        if (this.coordValueDate != null) {
            f.format(" coordValueDate='%s'", new DateFormatter().toDateTimeString(this.coordValueDate));
        }
        f.format(" range=[%d:%d) (%d)%n", this.aggStart, this.aggEnd, this.ncoord);
    }

    public int getNcoords(CancelTask cancelTask) throws IOException {
        block18: {
            if (this.ncoord <= 0) {
                try (NetcdfFile ncd = this.acquireFile(cancelTask);){
                    if (cancelTask != null && cancelTask.isCancel()) {
                        int n = 0;
                        return n;
                    }
                    Dimension d = ncd.findDimension(this.aggregationOuter.dimName);
                    if (d != null) {
                        this.ncoord = d.getLength();
                        break block18;
                    }
                    throw new IllegalArgumentException("Dimension not found= " + this.aggregationOuter.dimName);
                }
            }
        }
        return this.ncoord;
    }

    protected int setStartEnd(int aggStart, CancelTask cancelTask) throws IOException {
        this.aggStart = aggStart;
        this.aggEnd = aggStart + this.getNcoords(cancelTask);
        return this.ncoord;
    }

    protected Range getNestedJoinRange(Range totalRange) throws InvalidRangeException {
        int wantStop;
        int wantStart = totalRange.first();
        if (!this.isNeeded(wantStart, wantStop = totalRange.last() + 1)) {
            return null;
        }
        int firstInInterval = totalRange.getFirstInInterval(this.aggStart);
        if (firstInInterval < 0 || firstInInterval >= this.aggEnd) {
            return null;
        }
        int start = Math.max(firstInInterval, wantStart) - this.aggStart;
        int stop = Math.min(this.aggEnd, wantStop) - this.aggStart;
        return new Range(start, stop - 1, totalRange.stride());
    }

    protected boolean isNeeded(Range totalRange) {
        int wantStart = totalRange.first();
        int wantStop = totalRange.last() + 1;
        return this.isNeeded(wantStart, wantStop);
    }

    private boolean isNeeded(int wantStart, int wantStop) {
        if (wantStart >= wantStop) {
            return false;
        }
        return wantStart < this.aggEnd && wantStop > this.aggStart;
    }

    @Override
    protected void cacheVariables(NetcdfFile ncfile) throws IOException {
        for (AggregationOuter.CacheVar pv : this.aggregationOuter.cacheList) {
            pv.read(this, ncfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Array read(Variable mainv, CancelTask cancelTask, List<Range> section) throws IOException, InvalidRangeException {
        NetcdfFile ncd = null;
        try {
            ncd = this.acquireFile(cancelTask);
            if (cancelTask != null && cancelTask.isCancel()) {
                Array array = null;
                return array;
            }
            Variable v = this.findVariable(ncd, mainv);
            if (v == null) {
                Aggregation.logger.error("AggOuterDimension cant find " + mainv.getFullName() + " in " + ncd.getLocation() + "; return all zeroes!!!");
                Array array = Array.factory(mainv.getDataType(), new Section(section).getShape());
                return array;
            }
            if (Aggregation.debugRead) {
                Section want = new Section(section);
                System.out.printf("AggOuter.read(%s) %s from %s in %s%n", want, mainv.getNameAndDimensions(), v.getNameAndDimensions(), this.getLocation());
            }
            Range fullRange = (Range)v.getRanges().get(0);
            Range want = section.get(0);
            if (fullRange.last() < want.last()) {
                Range limitRange = new Range(want.first(), fullRange.last(), want.stride());
                section = new ArrayList<Range>(section);
                section.set(0, limitRange);
            }
            Array array = v.read(section);
            return array;
        }
        finally {
            this.close(ncd);
        }
    }

    @Override
    public int compareTo(AggDataset o) {
        if (o instanceof AggDatasetOuter && this.coordValueDate != null) {
            return this.coordValueDate.compareTo(((AggDatasetOuter)o).coordValueDate);
        }
        return super.compareTo(o);
    }
}

