/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.common.utils.VectorUtils;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.utils.IdGeneratorUtils;

public class FakeDataRandomUtils {
    private final FakeConfig fakeConfig;
    private final String jobId;

    public FakeDataRandomUtils(FakeConfig fakeConfig, String jobId) {
        this.fakeConfig = fakeConfig;
        this.jobId = jobId;
    }

    private static <T> T randomFromList(List<T> list) {
        int index = RandomUtils.nextInt((int)0, (int)list.size());
        return list.get(index);
    }

    public Boolean randomBoolean(Column column) {
        return RandomUtils.nextInt((int)0, (int)2) == 1;
    }

    public BigDecimal randomBigDecimal(Column column) {
        DecimalType dataType = (DecimalType)column.getDataType();
        return new BigDecimal(RandomStringUtils.randomNumeric((int)(dataType.getPrecision() - dataType.getScale())) + "." + RandomStringUtils.randomNumeric((int)dataType.getScale()));
    }

    public byte[] randomBytes(Column column) {
        return RandomStringUtils.randomAlphabetic((int)this.fakeConfig.getBytesLength()).getBytes();
    }

    public String randomString(Column column) {
        List<String> stringTemplate = this.fakeConfig.getStringTemplate();
        if (!CollectionUtils.isEmpty(stringTemplate)) {
            return FakeDataRandomUtils.randomFromList(stringTemplate);
        }
        return RandomStringUtils.randomAlphabetic((int)(column.getColumnLength() != null ? column.getColumnLength().intValue() : this.fakeConfig.getStringLength()));
    }

    public Byte randomTinyint(Column column) {
        List<Integer> tinyintTemplate = this.fakeConfig.getTinyintTemplate();
        if (!CollectionUtils.isEmpty(tinyintTemplate)) {
            return FakeDataRandomUtils.randomFromList(tinyintTemplate).byteValue();
        }
        return (byte)RandomUtils.nextInt((int)this.fakeConfig.getTinyintMin(), (int)this.fakeConfig.getTinyintMax());
    }

    public Short randomSmallint(Column column) {
        List<Integer> smallintTemplate = this.fakeConfig.getSmallintTemplate();
        if (!CollectionUtils.isEmpty(smallintTemplate)) {
            return FakeDataRandomUtils.randomFromList(smallintTemplate).shortValue();
        }
        return (short)RandomUtils.nextInt((int)this.fakeConfig.getSmallintMin(), (int)this.fakeConfig.getSmallintMax());
    }

    public Integer randomInt(Column column) {
        if (this.fakeConfig.getAutoIncrementEnabled().booleanValue() && IdGeneratorUtils.isPrimaryColumn(this.fakeConfig, column.getName())) {
            if (this.fakeConfig.getAutoIncrementStart() + (long)this.fakeConfig.getParallelism() * (long)this.fakeConfig.getRowNum() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("The auto increment start value is too large, please check your configuration.");
            }
            return IdGeneratorUtils.getIdGenerator(this.jobId, this.fakeConfig, column.getName()).orElseThrow(() -> new IllegalArgumentException("Auto increment is enabled, but no id generator found.")).getNextId().intValue();
        }
        List<Integer> intTemplate = this.fakeConfig.getIntTemplate();
        if (!CollectionUtils.isEmpty(intTemplate)) {
            return FakeDataRandomUtils.randomFromList(intTemplate);
        }
        return RandomUtils.nextInt((int)this.fakeConfig.getIntMin(), (int)this.fakeConfig.getIntMax());
    }

    public Long randomBigint(Column column) {
        if (this.fakeConfig.getAutoIncrementEnabled().booleanValue() && IdGeneratorUtils.isPrimaryColumn(this.fakeConfig, column.getName())) {
            return IdGeneratorUtils.getIdGenerator(this.jobId, this.fakeConfig, column.getName()).orElseThrow(() -> new IllegalArgumentException("Auto increment is enabled, but no id generator found.")).getNextId();
        }
        List<Long> bigTemplate = this.fakeConfig.getBigTemplate();
        if (!CollectionUtils.isEmpty(bigTemplate)) {
            return FakeDataRandomUtils.randomFromList(bigTemplate);
        }
        return RandomUtils.nextLong((long)this.fakeConfig.getBigintMin(), (long)this.fakeConfig.getBigintMax());
    }

    public Float randomFloat(Column column) {
        List<Double> floatTemplate = this.fakeConfig.getFloatTemplate();
        if (!CollectionUtils.isEmpty(floatTemplate)) {
            return Float.valueOf(FakeDataRandomUtils.randomFromList(floatTemplate).floatValue());
        }
        float v = RandomUtils.nextFloat((float)((float)this.fakeConfig.getFloatMin()), (float)((float)this.fakeConfig.getFloatMax()));
        return Float.valueOf(column.getScale() == null ? v : new BigDecimal(v).setScale((int)column.getScale(), RoundingMode.HALF_UP).floatValue());
    }

    public Double randomDouble(Column column) {
        List<Double> doubleTemplate = this.fakeConfig.getDoubleTemplate();
        if (!CollectionUtils.isEmpty(doubleTemplate)) {
            return FakeDataRandomUtils.randomFromList(doubleTemplate);
        }
        double v = RandomUtils.nextDouble((double)this.fakeConfig.getDoubleMin(), (double)this.fakeConfig.getDoubleMax());
        return column.getScale() == null ? v : (double)new BigDecimal(v).setScale((int)column.getScale(), RoundingMode.HALF_UP).floatValue();
    }

    public LocalDate randomLocalDate(Column column) {
        return this.randomLocalDateTime(column).toLocalDate();
    }

    public LocalTime randomLocalTime(Column column) {
        return this.randomLocalDateTime(column).toLocalTime();
    }

    public LocalDateTime randomLocalDateTime(Column column) {
        int year = !CollectionUtils.isEmpty(this.fakeConfig.getDateYearTemplate()) ? FakeDataRandomUtils.randomFromList(this.fakeConfig.getDateYearTemplate()).intValue() : LocalDateTime.now().getYear();
        int month = !CollectionUtils.isEmpty(this.fakeConfig.getDateMonthTemplate()) ? FakeDataRandomUtils.randomFromList(this.fakeConfig.getDateMonthTemplate()) : RandomUtils.nextInt((int)1, (int)13);
        int day = !CollectionUtils.isEmpty(this.fakeConfig.getDateDayTemplate()) ? FakeDataRandomUtils.randomFromList(this.fakeConfig.getDateDayTemplate()) : RandomUtils.nextInt((int)1, (int)29);
        int hour = !CollectionUtils.isEmpty(this.fakeConfig.getTimeHourTemplate()) ? FakeDataRandomUtils.randomFromList(this.fakeConfig.getTimeHourTemplate()) : RandomUtils.nextInt((int)0, (int)24);
        int minute = !CollectionUtils.isEmpty(this.fakeConfig.getTimeMinuteTemplate()) ? FakeDataRandomUtils.randomFromList(this.fakeConfig.getTimeMinuteTemplate()) : RandomUtils.nextInt((int)0, (int)60);
        int second = !CollectionUtils.isEmpty(this.fakeConfig.getTimeSecondTemplate()) ? FakeDataRandomUtils.randomFromList(this.fakeConfig.getTimeSecondTemplate()) : RandomUtils.nextInt((int)0, (int)60);
        return LocalDateTime.of(year, month, day, hour, minute, second);
    }

    public ByteBuffer randomBinaryVector(Column column) {
        int byteCount = column.getScale() != null ? column.getScale() / 8 : this.fakeConfig.getBinaryVectorDimension() / 8;
        return ByteBuffer.wrap(RandomUtils.nextBytes((int)byteCount));
    }

    public ByteBuffer randomFloatVector(Column column) {
        int count = column.getScale() != null ? column.getScale().intValue() : this.fakeConfig.getVectorDimension();
        Float[] floatVector = new Float[count];
        for (int i = 0; i < count; ++i) {
            floatVector[i] = Float.valueOf(RandomUtils.nextFloat((float)this.fakeConfig.getVectorFloatMin(), (float)this.fakeConfig.getVectorFloatMax()));
        }
        return VectorUtils.toByteBuffer((Float[])floatVector);
    }

    public ByteBuffer randomFloat16Vector(Column column) {
        int count = column.getScale() != null ? column.getScale().intValue() : this.fakeConfig.getVectorDimension();
        Short[] float16Vector = new Short[count];
        for (int i = 0; i < count; ++i) {
            float value = RandomUtils.nextFloat((float)this.fakeConfig.getVectorFloatMin(), (float)this.fakeConfig.getVectorFloatMax());
            float16Vector[i] = FakeDataRandomUtils.floatToFloat16(value);
        }
        return VectorUtils.toByteBuffer((Short[])float16Vector);
    }

    public ByteBuffer randomBFloat16Vector(Column column) {
        int count = column.getScale() != null ? column.getScale().intValue() : this.fakeConfig.getVectorDimension();
        Short[] bfloat16Vector = new Short[count];
        for (int i = 0; i < count; ++i) {
            float value = RandomUtils.nextFloat((float)this.fakeConfig.getVectorFloatMin(), (float)this.fakeConfig.getVectorFloatMax());
            bfloat16Vector[i] = FakeDataRandomUtils.floatToBFloat16(value);
        }
        return VectorUtils.toByteBuffer((Short[])bfloat16Vector);
    }

    public Map<Integer, Float> randomSparseFloatVector(Column column) {
        int nonZeroElements;
        HashMap<Integer, Float> sparseVector = new HashMap<Integer, Float>();
        int n = nonZeroElements = column.getScale() != null ? column.getScale().intValue() : this.fakeConfig.getVectorDimension();
        while (nonZeroElements > 0) {
            Integer index = RandomUtils.nextInt();
            Float value = Float.valueOf(RandomUtils.nextFloat((float)this.fakeConfig.getVectorFloatMin(), (float)this.fakeConfig.getVectorFloatMax()));
            if (sparseVector.containsKey(index)) continue;
            sparseVector.put(index, value);
            --nonZeroElements;
        }
        return sparseVector;
    }

    private static short floatToFloat16(float value) {
        int intBits = Float.floatToIntBits(value);
        int sign = intBits >>> 16 & 0x8000;
        int exponent = (intBits >>> 23 & 0xFF) - 112;
        int mantissa = intBits & 0x7FFFFF;
        if (exponent <= 0) {
            return (short)sign;
        }
        if (exponent > 31) {
            return (short)(sign | 0x7C00);
        }
        return (short)(sign | exponent << 10 | mantissa >> 13);
    }

    private static short floatToBFloat16(float value) {
        int intBits = Float.floatToIntBits(value);
        return (short)(intBits >> 16);
    }
}

