/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.expression;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.ArrayOpCode;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.TypeInstruction;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

class NewArrayBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression length;
    private final ParameterizedType elementType;
    @Nullable
    private final List<BytecodeExpression> elements;

    public NewArrayBytecodeExpression(ParameterizedType type, int length) {
        this(type, BytecodeExpressions.constantInt(length));
    }

    public NewArrayBytecodeExpression(ParameterizedType type, BytecodeExpression length) {
        this(type, length, null);
    }

    public NewArrayBytecodeExpression(ParameterizedType type, List<BytecodeExpression> elements) {
        this(type, BytecodeExpressions.constantInt(elements.size()), elements);
    }

    private NewArrayBytecodeExpression(ParameterizedType type, BytecodeExpression length, List<BytecodeExpression> elements) {
        super(type);
        Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((type.getArrayComponentType() != null ? 1 : 0) != 0, (String)"type %s must be array type", (Object)type);
        this.elementType = type.getArrayComponentType();
        this.length = Objects.requireNonNull(length, "length is null");
        this.elements = elements == null ? null : ImmutableList.copyOf(elements);
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        BytecodeBlock bytecodeBlock = this.elementType.isPrimitive() ? new BytecodeBlock().append(this.length).append(TypeInstruction.newPrimitiveArray(this.elementType)) : new BytecodeBlock().append(this.length).append(TypeInstruction.newObjectArray(this.elementType));
        if (this.elements != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                BytecodeExpression element = this.elements.get(i);
                bytecodeBlock.dup().append(BytecodeExpressions.constantInt(i)).append(element).append(ArrayOpCode.getArrayOpCode(this.elementType).getStore());
            }
        }
        return bytecodeBlock;
    }

    @Override
    protected String formatOneLine() {
        if (this.elements == null) {
            return "new " + this.elementType.getSimpleName() + "[" + this.length + "]";
        }
        return "new " + this.elementType.getSimpleName() + "[] {" + Joiner.on((String)", ").join(this.elements) + "}";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }
}

