/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import lombok.Generated;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.functions.api.SerDe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class JavaSerDe
implements SerDe<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaSerDe.class);
    private static final JavaSerDe INSTANCE = new JavaSerDe();

    public static JavaSerDe of() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(Object resultValue) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(resultValue);
                out.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (Exception ex) {
            log.info("Exception during serialization", ex);
            return null;
        }
    }

    @Override
    public Object deserialize(byte[] data) {
        Object obj = null;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(data);
             ObjectInputStream ois = new ObjectInputStream(bis);){
            obj = ois.readObject();
        }
        catch (Exception ex) {
            log.info("Exception during deserialization", ex);
        }
        return obj;
    }
}

