/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.ExpressionNodeInliner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DereferencePushdown;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SubscriptExpression;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ExtractDereferencesFromFilterAboveScan
implements Rule<FilterNode> {
    private static final Capture<TableScanNode> CHILD = Capture.newCapture();
    private final TypeAnalyzer typeAnalyzer;

    public ExtractDereferencesFromFilterAboveScan(TypeAnalyzer typeAnalyzer) {
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return Patterns.filter().with(Patterns.source().matching(Patterns.tableScan().capturedAs(CHILD)));
    }

    @Override
    public Rule.Result apply(FilterNode node, Captures captures, Rule.Context context) {
        Set<SubscriptExpression> dereferences = DereferencePushdown.extractRowSubscripts((Collection<Expression>)ImmutableList.of((Object)node.getPredicate()), true, context.getSession(), this.typeAnalyzer, context.getSymbolAllocator().getTypes());
        if (dereferences.isEmpty()) {
            return Rule.Result.empty();
        }
        Assignments assignments = Assignments.of(dereferences, context.getSession(), context.getSymbolAllocator(), this.typeAnalyzer);
        Map mappings = (Map)HashBiMap.create(assignments.getMap()).inverse().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Symbol)entry.getValue()).toSymbolReference()));
        PlanNode source = node.getSource();
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), new FilterNode(context.getIdAllocator().getNextId(), new ProjectNode(context.getIdAllocator().getNextId(), source, Assignments.builder().putIdentities(source.getOutputSymbols()).putAll(assignments).build()), ExpressionNodeInliner.replaceExpression(node.getPredicate(), mappings)), Assignments.identity(node.getOutputSymbols())));
    }
}

