/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.AggregationStatsRule;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.TableWriterNode;
import java.util.Optional;

public class ApplyPreferredTableWriterPartitioning
implements Rule<TableWriterNode> {
    public static final Pattern<TableWriterNode> WRITER_NODE_WITH_PREFERRED_PARTITIONING = Patterns.tableWriterNode().matching(node -> node.getPreferredPartitioningScheme().isPresent());

    @Override
    public Pattern<TableWriterNode> getPattern() {
        return WRITER_NODE_WITH_PREFERRED_PARTITIONING;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isUsePreferredWritePartitioning(session);
    }

    @Override
    public Rule.Result apply(TableWriterNode node, Captures captures, Rule.Context context) {
        int minimumNumberOfPartitions = SystemSessionProperties.getPreferredWritePartitioningMinNumberOfPartitions(context.getSession());
        if (minimumNumberOfPartitions <= 1) {
            return this.enable(node);
        }
        double expectedNumberOfPartitions = AggregationStatsRule.getRowsCount(context.getStatsProvider().getStats(node.getSource()), node.getPreferredPartitioningScheme().get().getPartitioning().getColumns());
        if (Double.isNaN(expectedNumberOfPartitions) || expectedNumberOfPartitions < (double)minimumNumberOfPartitions) {
            return Rule.Result.empty();
        }
        return this.enable(node);
    }

    private Rule.Result enable(TableWriterNode node) {
        return Rule.Result.ofPlanNode(new TableWriterNode(node.getId(), node.getSource(), node.getTarget(), node.getRowCountSymbol(), node.getFragmentSymbol(), node.getColumns(), node.getColumnNames(), node.getNotNullColumnSymbols(), node.getPreferredPartitioningScheme(), Optional.empty(), node.getStatisticsAggregation(), node.getStatisticsAggregationDescriptor()));
    }
}

