/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spiller;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.operator.SpillContext;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.spiller.SingleStreamSpiller;
import io.trino.spiller.SingleStreamSpillerFactory;
import io.trino.spiller.Spiller;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class GenericSpiller
implements Spiller {
    private final List<Type> types;
    private final SpillContext spillContext;
    private final AggregatedMemoryContext aggregatedMemoryContext;
    private final SingleStreamSpillerFactory singleStreamSpillerFactory;
    private final Closer closer = Closer.create();
    private ListenableFuture<Void> previousSpill = Futures.immediateVoidFuture();
    private final List<SingleStreamSpiller> singleStreamSpillers = new ArrayList<SingleStreamSpiller>();

    public GenericSpiller(List<Type> types, SpillContext spillContext, AggregatedMemoryContext aggregatedMemoryContext, SingleStreamSpillerFactory singleStreamSpillerFactory) {
        this.types = Objects.requireNonNull(types, "types cannot be null");
        this.spillContext = Objects.requireNonNull(spillContext, "spillContext cannot be null");
        this.aggregatedMemoryContext = Objects.requireNonNull(aggregatedMemoryContext, "aggregatedMemoryContext cannot be null");
        this.singleStreamSpillerFactory = Objects.requireNonNull(singleStreamSpillerFactory, "singleStreamSpillerFactory cannot be null");
    }

    @Override
    public ListenableFuture<Void> spill(Iterator<Page> pageIterator) {
        this.checkNoSpillInProgress();
        SingleStreamSpiller singleStreamSpiller = this.singleStreamSpillerFactory.create(this.types, this.spillContext, this.aggregatedMemoryContext.newLocalMemoryContext(GenericSpiller.class.getSimpleName()));
        this.closer.register((Closeable)singleStreamSpiller);
        this.singleStreamSpillers.add(singleStreamSpiller);
        this.previousSpill = singleStreamSpiller.spill(pageIterator);
        return this.previousSpill;
    }

    @Override
    public List<Iterator<Page>> getSpills() {
        this.checkNoSpillInProgress();
        return this.singleStreamSpillers.stream().map(SingleStreamSpiller::getSpilledPages).collect(Collectors.toList());
    }

    @Override
    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("could not close some single stream spillers", e);
        }
    }

    private void checkNoSpillInProgress() {
        Preconditions.checkState((boolean)this.previousSpill.isDone(), (Object)"previous spill still in progress");
    }
}

