/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.scheduler.OutputBufferManager;
import io.trino.sql.planner.PartitioningHandle;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PartitionedOutputBufferManager
implements OutputBufferManager {
    private final OutputBuffers outputBuffers;

    public PartitionedOutputBufferManager(PartitioningHandle partitioningHandle, int partitionCount) {
        Preconditions.checkArgument((partitionCount >= 1 ? 1 : 0) != 0, (Object)"partitionCount must be at least 1");
        ImmutableMap.Builder partitions = ImmutableMap.builder();
        for (int partition = 0; partition < partitionCount; ++partition) {
            partitions.put((Object)new OutputBuffers.OutputBufferId(partition), (Object)partition);
        }
        this.outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers(Objects.requireNonNull(partitioningHandle, "partitioningHandle is null")).withBuffers((Map<OutputBuffers.OutputBufferId, Integer>)partitions.build()).withNoMoreBufferIds();
    }

    @Override
    public void addOutputBuffer(OutputBuffers.OutputBufferId newBuffer) {
        Integer existingBufferId = this.outputBuffers.getBuffers().get(newBuffer);
        if (existingBufferId == null) {
            throw new IllegalStateException("Unexpected new output buffer " + newBuffer);
        }
        if (newBuffer.getId() != existingBufferId.intValue()) {
            throw new IllegalStateException("newOutputBuffers has changed the assignment for task " + newBuffer);
        }
    }

    @Override
    public void noMoreBuffers() {
    }

    @Override
    public OutputBuffers getOutputBuffers() {
        return this.outputBuffers;
    }
}

