/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import ch.qos.logback.core.LayoutBase;
import io.airlift.http.client.jetty.HttpRequestEvent;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

class HttpClientLogLayout
extends LayoutBase<HttpRequestEvent> {
    private static final DateTimeFormatter ISO_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());

    HttpClientLogLayout() {
    }

    public String doLayout(HttpRequestEvent event) {
        StringBuilder builder = new StringBuilder();
        builder.append(ISO_FORMATTER.format(event.getTimeStamp())).append('\t').append(event.getProtocolVersion()).append('\t').append(event.getMethod()).append('\t').append(event.getRequestUri()).append('\t').append(event.getResponseCode()).append('\t').append(event.getResponseSize()).append('\t').append(event.getRequestTotalTime()).append('\t').append(event.getRequestQueueTime()).append('\t').append(event.getRequestBeginToRequestEnd()).append('\t').append(event.getRequestEndToResponseBegin()).append('\t').append(event.getResponseBeginToResponseEnd()).append('\t').append(event.getTimeToLastByte()).append('\t').append(event.getTraceToken()).append('\n');
        return builder.toString();
    }
}

