/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.m3ql.time;

import java.time.Duration;
import java.util.Collection;
import org.apache.pinot.tsdb.m3ql.time.QueryTimeBoundaryConstraints;
import org.apache.pinot.tsdb.spi.RangeTimeSeriesRequest;
import org.apache.pinot.tsdb.spi.TimeBuckets;
import org.apache.pinot.tsdb.spi.plan.BaseTimeSeriesPlanNode;
import org.apache.pinot.tsdb.spi.plan.LeafTimeSeriesPlanNode;

public class TimeBucketComputer {
    private TimeBucketComputer() {
    }

    public static TimeBuckets compute(BaseTimeSeriesPlanNode planNode, RangeTimeSeriesRequest request) {
        QueryTimeBoundaryConstraints constraints = TimeBucketComputer.process(planNode, request);
        long newStartTime = request.getStartSeconds() - constraints.getLeftExtensionSeconds();
        long newEndTime = request.getEndSeconds() + constraints.getRightExtensionSeconds();
        long lcmOfDivisors = TimeBucketComputer.lcm(constraints.getDivisors());
        long roundStartTimeDelta = (lcmOfDivisors - (newEndTime - newStartTime) % lcmOfDivisors) % lcmOfDivisors;
        int numItems = (int)((newEndTime - (newStartTime -= roundStartTimeDelta)) / request.getStepSeconds());
        return TimeBuckets.ofSeconds((long)newStartTime, (Duration)Duration.ofSeconds(request.getStepSeconds()), (int)numItems);
    }

    public static QueryTimeBoundaryConstraints process(BaseTimeSeriesPlanNode planNode, RangeTimeSeriesRequest request) {
        if (planNode instanceof LeafTimeSeriesPlanNode) {
            QueryTimeBoundaryConstraints constraints = new QueryTimeBoundaryConstraints();
            constraints.getDivisors().add(request.getStepSeconds());
            return constraints;
        }
        QueryTimeBoundaryConstraints constraints = new QueryTimeBoundaryConstraints();
        for (BaseTimeSeriesPlanNode childNode : planNode.getInputs()) {
            QueryTimeBoundaryConstraints childConstraints = TimeBucketComputer.process(childNode, request);
            constraints = QueryTimeBoundaryConstraints.merge(constraints, childConstraints);
        }
        return constraints;
    }

    public static long lcm(Collection<Long> values) {
        long result = 1L;
        for (long value : values) {
            result = TimeBucketComputer.lcm(result, value);
        }
        return result;
    }

    public static long lcm(long a, long b) {
        return a * b / TimeBucketComputer.gcd(a, b);
    }

    public static long gcd(long a, long b) {
        if (a < b) {
            return TimeBucketComputer.gcd(b, a);
        }
        if (b == 0L) {
            return a;
        }
        return TimeBucketComputer.gcd(b, a % b);
    }
}

