/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.URLPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LocalResourcePBImpl
extends LocalResource {
    YarnProtos.LocalResourceProto proto = YarnProtos.LocalResourceProto.getDefaultInstance();
    YarnProtos.LocalResourceProto.Builder builder = null;
    boolean viaProto = false;
    private URL url = null;

    public LocalResourcePBImpl() {
        this.builder = YarnProtos.LocalResourceProto.newBuilder();
    }

    public LocalResourcePBImpl(YarnProtos.LocalResourceProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnProtos.LocalResourceProto getProto() {
        this.mergeLocalToBuilder();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((LocalResourcePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    private synchronized void mergeLocalToBuilder() {
        YarnProtos.LocalResourceProtoOrBuilder l;
        YarnProtos.LocalResourceProtoOrBuilder localResourceProtoOrBuilder = l = this.viaProto ? this.proto : this.builder;
        if (this.url != null && !l.getResource().equals(((URLPBImpl)this.url).getProto())) {
            this.maybeInitBuilder();
            l = this.builder;
            this.builder.setResource(this.convertToProtoFormat(this.url));
        }
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.LocalResourceProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public synchronized long getSize() {
        YarnProtos.LocalResourceProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getSize();
    }

    @Override
    public synchronized void setSize(long size) {
        this.maybeInitBuilder();
        this.builder.setSize(size);
    }

    @Override
    public synchronized long getTimestamp() {
        YarnProtos.LocalResourceProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getTimestamp();
    }

    @Override
    public synchronized void setTimestamp(long timestamp) {
        this.maybeInitBuilder();
        this.builder.setTimestamp(timestamp);
    }

    @Override
    public synchronized LocalResourceType getType() {
        YarnProtos.LocalResourceProtoOrBuilder p;
        YarnProtos.LocalResourceProtoOrBuilder localResourceProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasType()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getType());
    }

    @Override
    public synchronized void setType(LocalResourceType type) {
        this.maybeInitBuilder();
        if (type == null) {
            this.builder.clearType();
            return;
        }
        this.builder.setType(this.convertToProtoFormat(type));
    }

    @Override
    public synchronized URL getResource() {
        YarnProtos.LocalResourceProtoOrBuilder p;
        YarnProtos.LocalResourceProtoOrBuilder localResourceProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.url != null) {
            return this.url;
        }
        if (!p.hasResource()) {
            return null;
        }
        this.url = this.convertFromProtoFormat(p.getResource());
        return this.url;
    }

    @Override
    public synchronized void setResource(URL resource) {
        this.maybeInitBuilder();
        if (resource == null) {
            this.builder.clearResource();
        }
        this.url = resource;
    }

    @Override
    public synchronized LocalResourceVisibility getVisibility() {
        YarnProtos.LocalResourceProtoOrBuilder p;
        YarnProtos.LocalResourceProtoOrBuilder localResourceProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasVisibility()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getVisibility());
    }

    @Override
    public synchronized void setVisibility(LocalResourceVisibility visibility) {
        this.maybeInitBuilder();
        if (visibility == null) {
            this.builder.clearVisibility();
            return;
        }
        this.builder.setVisibility(this.convertToProtoFormat(visibility));
    }

    @Override
    public synchronized String getPattern() {
        YarnProtos.LocalResourceProtoOrBuilder p;
        YarnProtos.LocalResourceProtoOrBuilder localResourceProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasPattern()) {
            return null;
        }
        return p.getPattern();
    }

    @Override
    public synchronized void setPattern(String pattern) {
        this.maybeInitBuilder();
        if (pattern == null) {
            this.builder.clearPattern();
            return;
        }
        this.builder.setPattern(pattern);
    }

    @Override
    public synchronized boolean getShouldBeUploadedToSharedCache() {
        YarnProtos.LocalResourceProtoOrBuilder p;
        YarnProtos.LocalResourceProtoOrBuilder localResourceProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasShouldBeUploadedToSharedCache()) {
            return false;
        }
        return p.getShouldBeUploadedToSharedCache();
    }

    @Override
    public synchronized void setShouldBeUploadedToSharedCache(boolean shouldBeUploadedToSharedCache) {
        this.maybeInitBuilder();
        if (!shouldBeUploadedToSharedCache) {
            this.builder.clearShouldBeUploadedToSharedCache();
            return;
        }
        this.builder.setShouldBeUploadedToSharedCache(shouldBeUploadedToSharedCache);
    }

    private YarnProtos.LocalResourceTypeProto convertToProtoFormat(LocalResourceType e) {
        return ProtoUtils.convertToProtoFormat(e);
    }

    private LocalResourceType convertFromProtoFormat(YarnProtos.LocalResourceTypeProto e) {
        return ProtoUtils.convertFromProtoFormat(e);
    }

    private URLPBImpl convertFromProtoFormat(YarnProtos.URLProto p) {
        return new URLPBImpl(p);
    }

    private YarnProtos.URLProto convertToProtoFormat(URL t2) {
        return ((URLPBImpl)t2).getProto();
    }

    private YarnProtos.LocalResourceVisibilityProto convertToProtoFormat(LocalResourceVisibility e) {
        return ProtoUtils.convertToProtoFormat(e);
    }

    private LocalResourceVisibility convertFromProtoFormat(YarnProtos.LocalResourceVisibilityProto e) {
        return ProtoUtils.convertFromProtoFormat(e);
    }
}

