/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.sun.jna.LastErrorException;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.win32.StdCallLibrary;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface WindowsCredentialApi
extends StdCallLibrary {
    public static final int CRED_TYPE_GENERIC = 1;

    public boolean CredRead(String var1, int var2, int var3, PCREDENTIAL var4) throws LastErrorException;

    public void CredFree(Pointer var1) throws LastErrorException;

    public static class PCREDENTIAL
    extends Structure {
        public Pointer credential;

        @Override
        protected List<String> getFieldOrder() {
            return Collections.singletonList("credential");
        }

        public PCREDENTIAL() {
        }

        public PCREDENTIAL(byte[] data) {
            super(new Memory(data.length));
            this.getPointer().write(0L, data, 0, data.length);
            this.read();
        }

        public PCREDENTIAL(Pointer memory) {
            super(memory);
            this.read();
        }
    }

    public static class CREDENTIAL
    extends Structure {
        public int Flags;
        public int Type;
        public String TargetName;
        public String Comment;
        public WinBase.FILETIME LastWritten;
        public int CredentialBlobSize;
        public Pointer CredentialBlob;
        public int Persist;
        public int AttributeCount;
        public CREDENTIAL_ATTRIBUTE.ByReference Attributes;
        public String TargetAlias;
        public String UserName;

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("Flags", "Type", "TargetName", "Comment", "LastWritten", "CredentialBlobSize", "CredentialBlob", "Persist", "AttributeCount", "Attributes", "TargetAlias", "UserName");
        }

        public CREDENTIAL() {
        }

        public CREDENTIAL(int size) {
            super(new Memory(size));
        }

        public CREDENTIAL(Pointer memory) {
            super(memory);
            this.read();
        }
    }

    public static class CREDENTIAL_ATTRIBUTE
    extends Structure {
        public String Keyword;
        public int Flags;
        public int ValueSize;
        public Pointer Value;

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("Keyword", "Flags", "ValueSize", "Value");
        }

        public static class ByReference
        extends CREDENTIAL_ATTRIBUTE
        implements Structure.ByReference {
        }
    }
}

