/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SecureShuffleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecureShuffleUtils.class);
    public static final String HTTP_HEADER_URL_HASH = "UrlHash";
    public static final String HTTP_HEADER_REPLY_URL_HASH = "ReplyHash";

    public static String generateHash(byte[] msg, SecretKey key) {
        return new String(Base64.encodeBase64(SecureShuffleUtils.generateByteHash(msg, key)), StandardCharsets.UTF_8);
    }

    private static byte[] generateByteHash(byte[] msg, SecretKey key) {
        return JobTokenSecretManager.computeHash(msg, key);
    }

    private static boolean verifyHash(byte[] hash, byte[] msg, SecretKey key) {
        byte[] msg_hash = SecureShuffleUtils.generateByteHash(msg, key);
        return WritableComparator.compareBytes((byte[])msg_hash, (int)0, (int)msg_hash.length, (byte[])hash, (int)0, (int)hash.length) == 0;
    }

    public static String hashFromString(String enc_str, SecretKey key) throws IOException {
        return SecureShuffleUtils.generateHash(enc_str.getBytes(StandardCharsets.UTF_8), key);
    }

    public static void verifyReply(String base64Hash, String msg, SecretKey key) throws IOException {
        byte[] hash = Base64.decodeBase64(base64Hash.getBytes(StandardCharsets.UTF_8));
        boolean res = SecureShuffleUtils.verifyHash(hash, msg.getBytes(StandardCharsets.UTF_8), key);
        if (!res) {
            throw new IOException("Verification of the hashReply failed");
        }
    }

    public static String buildMsgFrom(URL url) {
        return SecureShuffleUtils.buildMsgFrom(url.getPath(), url.getQuery(), url.getPort());
    }

    public static String buildMsgFrom(HttpServletRequest request) {
        return SecureShuffleUtils.buildMsgFrom(request.getRequestURI(), request.getQueryString(), request.getLocalPort());
    }

    private static String buildMsgFrom(String uri_path, String uri_query, int port) {
        return String.valueOf(port) + uri_path + "?" + uri_query;
    }

    public static String toHex(byte[] ba) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String strHex = "";
        try {
            PrintStream ps = new PrintStream((OutputStream)baos, false, "UTF-8");
            for (byte b : ba) {
                ps.printf("%x", b);
            }
            strHex = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return strHex;
    }
}

