/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka20;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.utils.Bytes;
import org.apache.pinot.plugin.stream.kafka.KafkaMessageBatch;
import org.apache.pinot.plugin.stream.kafka20.KafkaPartitionLevelConnectionHandler;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.stream.BytesStreamMessage;
import org.apache.pinot.spi.stream.LongMsgOffset;
import org.apache.pinot.spi.stream.PartitionGroupConsumer;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamMessageMetadata;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPartitionLevelConsumer
extends KafkaPartitionLevelConnectionHandler
implements PartitionGroupConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPartitionLevelConsumer.class);
    private long _lastFetchedOffset = -1L;

    public KafkaPartitionLevelConsumer(String clientId, StreamConfig streamConfig, int partition) {
        super(clientId, streamConfig, partition);
    }

    public synchronized KafkaMessageBatch fetchMessages(StreamPartitionMsgOffset startMsgOffset, int timeoutMs) {
        long startOffset = ((LongMsgOffset)startMsgOffset).getOffset();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Polling partition: {}, startOffset: {}, timeout: {}ms", this._topicPartition, startOffset, timeoutMs);
        }
        if (this._lastFetchedOffset < 0L || this._lastFetchedOffset != startOffset - 1L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Seeking to offset: {}", (Object)startOffset);
            }
            this._consumer.seek(this._topicPartition, startOffset);
        }
        ConsumerRecords consumerRecords = this._consumer.poll(Duration.ofMillis(timeoutMs));
        List records = consumerRecords.records(this._topicPartition);
        ArrayList<BytesStreamMessage> filteredRecords = new ArrayList<BytesStreamMessage>(records.size());
        long firstOffset = -1L;
        long offsetOfNextBatch = startOffset;
        StreamMessageMetadata lastMessageMetadata = null;
        if (!records.isEmpty()) {
            firstOffset = records.get(0).offset();
            this._lastFetchedOffset = records.get(records.size() - 1).offset();
            offsetOfNextBatch = this._lastFetchedOffset + 1L;
            for (ConsumerRecord<String, Bytes> consumerRecord : records) {
                StreamMessageMetadata messageMetadata = this.extractMessageMetadata(consumerRecord);
                Bytes message = consumerRecord.value();
                if (message != null) {
                    String key = consumerRecord.key();
                    byte[] keyBytes = key != null ? key.getBytes(StandardCharsets.UTF_8) : null;
                    filteredRecords.add(new BytesStreamMessage(keyBytes, message.get(), messageMetadata));
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Tombstone message at offset: {}", (Object)consumerRecord.offset());
                }
                lastMessageMetadata = messageMetadata;
            }
        }
        boolean hasDataLoss = false;
        if (this._config.getKafkaIsolationLevel() == null || this._config.getKafkaIsolationLevel().equals("read_uncommitted")) {
            hasDataLoss = firstOffset > startOffset;
        }
        return new KafkaMessageBatch(filteredRecords, records.size(), offsetOfNextBatch, firstOffset, lastMessageMetadata, hasDataLoss);
    }

    private StreamMessageMetadata extractMessageMetadata(ConsumerRecord<String, Bytes> record) {
        long timestamp = record.timestamp();
        long offset = record.offset();
        StreamMessageMetadata.Builder builder = new StreamMessageMetadata.Builder().setRecordIngestionTimeMs(timestamp).setOffset((StreamPartitionMsgOffset)new LongMsgOffset(offset), (StreamPartitionMsgOffset)new LongMsgOffset(offset + 1L)).setSerializedValueSize(record.serializedValueSize());
        if (this._config.isPopulateMetadata()) {
            Headers headers = record.headers();
            if (headers != null) {
                GenericRow headerGenericRow = new GenericRow();
                for (Header header : headers.toArray()) {
                    headerGenericRow.putValue(header.key(), (Object)header.value());
                }
                builder.setHeaders(headerGenericRow);
            }
            builder.setMetadata(Map.of("recordTimestamp", String.valueOf(timestamp), "offset", String.valueOf(offset), "partition", String.valueOf(record.partition())));
        }
        return builder.build();
    }
}

