/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.contrib.nio.CloudStorageFileAttributes;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystem;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.pinot.shaded.com.google.common.base.MoreObjects;
import org.apache.pinot.shaded.com.google.common.base.Optional;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableMap;

@Immutable
final class CloudStorageObjectAttributes
implements CloudStorageFileAttributes {
    @Nonnull
    private final BlobInfo info;

    CloudStorageObjectAttributes(BlobInfo info) {
        this.info = Preconditions.checkNotNull(info);
    }

    @Override
    public long size() {
        return this.info.getSize();
    }

    @Override
    public FileTime creationTime() {
        if (this.info.getUpdateTime() == null) {
            return CloudStorageFileSystem.FILE_TIME_UNKNOWN;
        }
        return FileTime.fromMillis(this.info.getUpdateTime());
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.creationTime();
    }

    @Override
    public Optional<String> etag() {
        return Optional.fromNullable(this.info.getEtag());
    }

    @Override
    public Optional<String> mimeType() {
        return Optional.fromNullable(this.info.getContentType());
    }

    @Override
    public Optional<List<Acl>> acl() {
        return Optional.fromNullable(this.info.getAcl());
    }

    @Override
    public Optional<String> cacheControl() {
        return Optional.fromNullable(this.info.getCacheControl());
    }

    @Override
    public Optional<String> contentEncoding() {
        return Optional.fromNullable(this.info.getContentEncoding());
    }

    @Override
    public Optional<String> contentDisposition() {
        return Optional.fromNullable(this.info.getContentDisposition());
    }

    public ImmutableMap<String, String> userMetadata() {
        if (null == this.info.getMetadata()) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(this.info.getMetadata());
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public boolean isRegularFile() {
        return true;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public FileTime lastAccessTime() {
        return CloudStorageFileSystem.FILE_TIME_UNKNOWN;
    }

    @Override
    public Object fileKey() {
        return this.info.getBlobId().getBucket() + this.info.getBlobId().getName() + this.info.getBlobId().getGeneration();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CloudStorageObjectAttributes && Objects.equals(this.info, ((CloudStorageObjectAttributes)other).info);
    }

    public int hashCode() {
        return this.info.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("info", this.info).toString();
    }
}

