/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.segmentgenerationandpush;

import java.util.HashMap;
import java.util.Map;

public class SegmentGenerationAndPushResult {
    private final boolean _succeed;
    private final String _segmentName;
    private final Exception _exception;
    private final Map<String, Object> _customProperties;

    private SegmentGenerationAndPushResult(boolean succeed, String segmentName, Exception exception, Map<String, Object> customProperties) {
        this._succeed = succeed;
        this._segmentName = segmentName;
        this._exception = exception;
        this._customProperties = customProperties;
    }

    public <T> T getCustomProperty(String key) {
        return (T)this._customProperties.get(key);
    }

    public Exception getException() {
        return this._exception;
    }

    public boolean isSucceed() {
        return this._succeed;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public static class Builder {
        private boolean _succeed;
        private String _segmentName;
        private Exception _exception;
        private final Map<String, Object> _customProperties = new HashMap<String, Object>();

        public Builder setSucceed(boolean succeed) {
            this._succeed = succeed;
            return this;
        }

        public void setSegmentName(String segmentName) {
            this._segmentName = segmentName;
        }

        public Builder setException(Exception exception) {
            this._exception = exception;
            return this;
        }

        public Builder setCustomProperty(String key, Object property) {
            this._customProperties.put(key, property);
            return this;
        }

        public SegmentGenerationAndPushResult build() {
            return new SegmentGenerationAndPushResult(this._succeed, this._segmentName, this._exception, this._customProperties);
        }
    }
}

