/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.helix.HelixManager;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.MinionMeter;
import org.apache.pinot.common.metrics.MinionMetrics;
import org.apache.pinot.common.utils.TarCompressionUtils;
import org.apache.pinot.common.utils.fetcher.SegmentFetcherFactory;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.core.util.PeerServerSegmentFinder;
import org.apache.pinot.minion.MinionContext;
import org.apache.pinot.minion.executor.PinotTaskExecutor;
import org.apache.pinot.plugin.minion.tasks.MinionTaskUtils;
import org.apache.pinot.plugin.minion.tasks.SegmentConversionResult;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTaskExecutor
implements PinotTaskExecutor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseTaskExecutor.class);
    protected static final MinionContext MINION_CONTEXT = MinionContext.getInstance();
    protected boolean _cancelled = false;
    protected final MinionMetrics _minionMetrics = MinionMetrics.get();

    public void cancel() {
        this._cancelled = true;
    }

    protected abstract SegmentZKMetadataCustomMapModifier getSegmentZKMetadataCustomMapModifier(PinotTaskConfig var1, SegmentConversionResult var2);

    protected TableConfig getTableConfig(String tableNameWithType) {
        TableConfig tableConfig = ZKMetadataProvider.getTableConfig((ZkHelixPropertyStore)MINION_CONTEXT.getHelixPropertyStore(), (String)tableNameWithType);
        Preconditions.checkState((tableConfig != null ? 1 : 0) != 0, (String)"Failed to find table config for table: %s", (Object)tableNameWithType);
        return tableConfig;
    }

    protected Schema getSchema(String tableName) {
        Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)MINION_CONTEXT.getHelixPropertyStore(), (String)tableName);
        Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for table: %s", (Object)tableName);
        return schema;
    }

    protected long getSegmentCrc(String tableNameWithType, String segmentName) {
        SegmentZKMetadata segmentZKMetadata = ZKMetadataProvider.getSegmentZKMetadata((ZkHelixPropertyStore)MINION_CONTEXT.getHelixPropertyStore(), (String)tableNameWithType, (String)segmentName);
        return segmentZKMetadata == null ? -1L : segmentZKMetadata.getCrc();
    }

    protected void reportSegmentDownloadMetrics(File indexDir, String tableNameWithType, String taskType) {
        long downloadSegmentSize = FileUtils.sizeOfDirectory((File)indexDir);
        this.addTaskMeterMetrics(MinionMeter.SEGMENT_BYTES_DOWNLOADED, downloadSegmentSize, tableNameWithType, taskType);
        this.addTaskMeterMetrics(MinionMeter.SEGMENT_DOWNLOAD_COUNT, 1L, tableNameWithType, taskType);
    }

    protected void reportSegmentUploadMetrics(File indexDir, String tableNameWithType, String taskType) {
        long uploadSegmentSize = FileUtils.sizeOfDirectory((File)indexDir);
        this.addTaskMeterMetrics(MinionMeter.SEGMENT_BYTES_UPLOADED, uploadSegmentSize, tableNameWithType, taskType);
        this.addTaskMeterMetrics(MinionMeter.SEGMENT_UPLOAD_COUNT, 1L, tableNameWithType, taskType);
    }

    protected void reportTaskProcessingMetrics(String tableNameWithType, String taskType, int numRecordsProcessed, int numRecordsPurged) {
        this.reportTaskProcessingMetrics(tableNameWithType, taskType, numRecordsProcessed);
        this.addTaskMeterMetrics(MinionMeter.RECORDS_PURGED_COUNT, numRecordsPurged, tableNameWithType, taskType);
    }

    protected void reportTaskProcessingMetrics(String tableNameWithType, String taskType, int numRecordsProcessed) {
        this.addTaskMeterMetrics(MinionMeter.RECORDS_PROCESSED_COUNT, numRecordsProcessed, tableNameWithType, taskType);
    }

    private void addTaskMeterMetrics(MinionMeter meter, long unitCount, String tableName, String taskType) {
        this._minionMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)meter, unitCount);
        this._minionMetrics.addMeteredTableValue(tableName, (AbstractMetrics.Meter)meter, unitCount);
        this._minionMetrics.addMeteredTableValue(tableName, taskType, (AbstractMetrics.Meter)meter, unitCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File downloadSegmentToLocalAndUntar(String tableNameWithType, String segmentName, String deepstoreURL, String taskType, File tempDataDir, String suffix) throws Exception {
        File indexDir;
        block7: {
            File tarredSegmentFile = new File(tempDataDir, "tarredSegmentFile" + suffix);
            File segmentDir = new File(tempDataDir, "segmentDir" + suffix);
            TableConfig tableConfig = this.getTableConfig(tableNameWithType);
            String crypterName = tableConfig.getValidationConfig().getCrypterClassName();
            LOGGER.info("Downloading segment {} from {} to {}", new Object[]{segmentName, deepstoreURL, tarredSegmentFile.getAbsolutePath()});
            try {
                SegmentFetcherFactory.fetchAndDecryptSegmentToLocal((String)deepstoreURL, (File)tarredSegmentFile, (String)crypterName);
                indexDir = (File)TarCompressionUtils.untar((File)tarredSegmentFile, (File)segmentDir).get(0);
            }
            catch (Exception e) {
                LOGGER.error("Segment download failed from deepstore for {}, crypter:{}", new Object[]{deepstoreURL, crypterName, e});
                String peerDownloadScheme = tableConfig.getValidationConfig().getPeerSegmentDownloadScheme();
                if (MinionTaskUtils.extractMinionAllowDownloadFromServer(tableConfig, taskType, MINION_CONTEXT.isAllowDownloadFromServer()) && peerDownloadScheme != null) {
                    LOGGER.info("Trying to download from servers for segment {} post deepstore download failed", (Object)segmentName);
                    SegmentFetcherFactory.fetchAndDecryptSegmentToLocal((String)segmentName, (String)peerDownloadScheme, () -> {
                        List uris = PeerServerSegmentFinder.getPeerServerURIs((HelixManager)MINION_CONTEXT.getHelixManager(), (String)tableNameWithType, (String)segmentName, (String)peerDownloadScheme);
                        Collections.shuffle(uris);
                        return uris;
                    }, (File)tarredSegmentFile, (String)crypterName);
                    indexDir = (File)TarCompressionUtils.untar((File)tarredSegmentFile, (File)segmentDir).get(0);
                    break block7;
                }
                throw e;
            }
            finally {
                if (!FileUtils.deleteQuietly((File)tarredSegmentFile)) {
                    LOGGER.warn("Failed to delete tarred input segment: {}", (Object)tarredSegmentFile.getAbsolutePath());
                }
            }
        }
        return indexDir;
    }
}

