/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.util.RubyDateFormatter;

public class RubyTimeOutputFormatter {
    final String flags;
    final int width;
    public static final RubyTimeOutputFormatter DEFAULT_FORMATTER = new RubyTimeOutputFormatter("", 0);

    public RubyTimeOutputFormatter(String flags, int width) {
        this.flags = flags;
        this.width = width;
    }

    public int getWidth(int defaultWidth) {
        if (this.flags.indexOf(45) != -1) {
            return 0;
        }
        return this.width != 0 ? this.width : defaultWidth;
    }

    public char getPadder(char defaultPadder) {
        int padder = defaultPadder;
        block5: for (int i2 = 0; i2 < this.flags.length(); ++i2) {
            switch (this.flags.charAt(i2)) {
                case '_': {
                    padder = 32;
                    continue block5;
                }
                case '0': {
                    padder = 48;
                    continue block5;
                }
                case '-': {
                    padder = 0;
                }
            }
        }
        return (char)padder;
    }

    public String format(String sequence, long value2, RubyDateFormatter.FieldType type2) {
        int width = this.getWidth(type2.defaultWidth);
        char padder = this.getPadder(type2.defaultPadder);
        sequence = sequence == null ? RubyTimeOutputFormatter.formatNumber(value2, width, padder) : RubyTimeOutputFormatter.padding(sequence, width, padder);
        block4: for (int i2 = 0; i2 < this.flags.length(); ++i2) {
            switch (this.flags.charAt(i2)) {
                case '^': {
                    sequence = sequence.toUpperCase();
                    continue block4;
                }
                case '#': {
                    char last2 = sequence.charAt(sequence.length() - 1);
                    sequence = Character.isLowerCase(last2) ? sequence.toUpperCase() : sequence.toLowerCase();
                }
            }
        }
        return sequence;
    }

    static String formatNumber(long value2, int width, char padder) {
        if (value2 >= 0L || padder != '0') {
            return RubyTimeOutputFormatter.padding(Long.toString(value2), width, padder);
        }
        return "-" + RubyTimeOutputFormatter.padding(Long.toString(-value2), width - 1, padder);
    }

    static String formatSignedNumber(long value2, int width, char padder) {
        if (padder == '0') {
            if (value2 >= 0L) {
                return "+" + RubyTimeOutputFormatter.padding(Long.toString(value2), width - 1, padder);
            }
            return "-" + RubyTimeOutputFormatter.padding(Long.toString(-value2), width - 1, padder);
        }
        if (value2 >= 0L) {
            return RubyTimeOutputFormatter.padding("+" + Long.toString(value2), width, padder);
        }
        return RubyTimeOutputFormatter.padding(Long.toString(value2), width, padder);
    }

    static String padding(String sequence, int width, char padder) {
        if (sequence.length() >= width) {
            return sequence;
        }
        StringBuilder buf = new StringBuilder(width + sequence.length());
        for (int i2 = sequence.length(); i2 < width; ++i2) {
            buf.append(padder);
        }
        buf.append(sequence);
        return buf.toString();
    }
}

