/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class EnsureRubyArrayInstr
extends Instr
implements ResultInstr {
    private Operand object;
    private Variable result;

    public EnsureRubyArrayInstr(Variable result2, Operand s2) {
        super(Operation.ENSURE_RUBY_ARRAY);
        assert (result2 != null) : "EnsureRubyArray result is null";
        this.object = s2;
        this.result = result2;
    }

    @Override
    public Operand simplifyAndGetResult(IRScope scope, Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap, false);
        return this.object instanceof Array ? this.object : null;
    }

    public Operand getObject() {
        return this.object;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.object};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.object = this.object.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.object + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new EnsureRubyArrayInstr(ii.getRenamedVariable(this.result), this.object.cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        IRubyObject val = (IRubyObject)this.object.retrieve(context, self2, currDynScope, temp);
        if (!(val instanceof RubyArray)) {
            val = ArgsUtil.convertToRubyArray(context.runtime, val, false);
        }
        return val;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.EnsureRubyArrayInstr(this);
    }
}

