/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.EvalFunc;
import org.apache.pig.builtin.InvokerFunction;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class InvokerGenerator
extends EvalFunc<Object> {
    private String className_;
    private String methodName_;
    private String[] argumentTypes_;
    private boolean isInitialized = false;
    private InvokerFunction generatedFunction;
    private Schema outputSchema;
    private static int uniqueId = 0;
    private static final Map<Class<?>, Byte> returnTypeMap = new HashMap<Class<?>, Byte>(){
        {
            this.put(String.class, (byte)55);
            this.put(Integer.class, (byte)10);
            this.put(Long.class, (byte)15);
            this.put(Float.class, (byte)20);
            this.put(Double.class, (byte)25);
            this.put(Boolean.class, (byte)5);
            this.put(Integer.TYPE, (byte)10);
            this.put(Long.TYPE, (byte)15);
            this.put(Float.TYPE, (byte)20);
            this.put(Double.TYPE, (byte)25);
            this.put(Boolean.TYPE, (byte)5);
        }
    };
    private static final Map<Class<?>, Class<?>> inverseTypeMap = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Integer.class, Integer.TYPE);
            this.put(Long.class, Long.TYPE);
            this.put(Float.class, Float.TYPE);
            this.put(Double.class, Double.TYPE);
            this.put(Boolean.class, Boolean.TYPE);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
            this.put(Boolean.TYPE, Boolean.class);
        }
    };
    private static final Map<Class<?>, String> primitiveSignature = new HashMap<Class<?>, String>(){
        {
            this.put(Integer.TYPE, "I");
            this.put(Long.TYPE, "J");
            this.put(Float.TYPE, "F");
            this.put(Double.TYPE, "D");
            this.put(Boolean.TYPE, "Z");
        }
    };
    private static final Map<String, Class<?>> nameToClassObjectMap = new HashMap<String, Class<?>>(){
        {
            this.put("String", String.class);
            this.put("Integer", Integer.class);
            this.put("int", Integer.TYPE);
            this.put("Long", Long.class);
            this.put("long", Long.TYPE);
            this.put("Float", Float.class);
            this.put("float", Float.TYPE);
            this.put("Double", Double.class);
            this.put("double", Double.TYPE);
            this.put("Boolean", Boolean.class);
            this.put("boolean", Boolean.TYPE);
            this.put("java.lang.String", String.class);
            this.put("java.lang.Integer", Integer.class);
            this.put("java.lang.Long", Long.class);
            this.put("java.lang.Float", Float.class);
            this.put("java.lang.Double", Double.class);
            this.put("java.lang.Boolean", Boolean.class);
        }
    };

    public InvokerGenerator(String className, String methodName, String argumentTypes) {
        this.className_ = className;
        this.methodName_ = methodName;
        this.argumentTypes_ = argumentTypes.split(",");
        if ("".equals(argumentTypes)) {
            this.argumentTypes_ = new String[0];
        }
    }

    @Override
    public Object exec(Tuple input) throws IOException {
        if (!this.isInitialized) {
            this.initialize();
        }
        return this.generatedFunction.eval(input);
    }

    @Override
    public Schema outputSchema(Schema input) {
        if (!this.isInitialized) {
            this.initialize();
        }
        return this.outputSchema;
    }

    private static int getUniqueId() {
        return uniqueId++;
    }

    protected void initialize() {
        Method method;
        Class clazz;
        try {
            clazz = PigContext.resolveClassName(this.className_);
        }
        catch (IOException e) {
            throw new RuntimeException("Given className not found: " + this.className_, e);
        }
        Class<?>[] arguments = this.getArgumentClassArray(this.argumentTypes_);
        try {
            method = clazz.getMethod(this.methodName_, arguments);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Not allowed to call given method[" + this.methodName_ + "] on class [" + this.className_ + "] with arguments: " + Arrays.toString(this.argumentTypes_), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Given method name [" + this.methodName_ + "] does not exist on class [" + this.className_ + "] with arguments: " + Arrays.toString(this.argumentTypes_), e);
        }
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        Class<?> returnClazz = method.getReturnType();
        Byte type = returnClazz.isPrimitive() ? returnTypeMap.get(inverseTypeMap.get(returnClazz)) : returnTypeMap.get(returnClazz);
        if (type == null) {
            throw new RuntimeException("Function returns invalid type: " + returnClazz);
        }
        this.outputSchema = new Schema();
        this.outputSchema.add(new Schema.FieldSchema(null, type));
        this.generatedFunction = this.generateInvokerFunction("InvokerFunction_" + InvokerGenerator.getUniqueId(), method, isStatic, arguments);
        this.isInitialized = true;
    }

    private Class<?>[] getArgumentClassArray(String[] argumentTypes) {
        Class[] arguments = new Class[argumentTypes.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            try {
                arguments[i] = nameToClassObjectMap.get(argumentTypes[i]);
                if (arguments[i] != null) continue;
                arguments[i] = PigContext.resolveClassName(argumentTypes[i]);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to find class in PigContext: " + argumentTypes[i], e);
            }
        }
        return arguments;
    }

    private InvokerFunction generateInvokerFunction(String className, Method method, boolean isStatic, Class<?>[] arguments) {
        byte[] byteCode = this.generateInvokerFunctionBytecode(className, method, isStatic, arguments);
        return ByteClassLoader.getInvokerFunction(className, byteCode);
    }

    private byte[] generateInvokerFunctionBytecode(String className, Method method, boolean isStatic, Class<?>[] arguments) {
        boolean isInterface = method.getDeclaringClass().isInterface();
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 33, className, null, "java/lang/Object", new String[]{"org/apache/pig/builtin/InvokerFunction"});
        this.makeConstructor(cw);
        MethodVisitor mv = cw.visitMethod(1, "eval", "(Lorg/apache/pig/data/Tuple;)Ljava/lang/Object;", null, new String[]{"java/io/IOException"});
        mv.visitCode();
        int next = 2;
        int begin = 0;
        if (!isStatic) {
            this.loadAndStoreArgument(mv, begin++, next++, this.getMethodStyleName(method.getDeclaringClass()));
        }
        for (int i = 0; i < arguments.length; ++i) {
            this.loadAndStoreArgument(mv, i + begin, next++, this.getMethodStyleName(this.getObjectVersion(arguments[i])));
        }
        next = 2;
        if (!isStatic) {
            mv.visitVarInsn(25, next++);
        }
        for (Class<?> arg : arguments) {
            mv.visitVarInsn(25, next++);
            this.unboxIfPrimitive(mv, arg);
        }
        String signature = this.buildSignatureString(arguments, method.getReturnType());
        mv.visitMethodInsn(isStatic ? 184 : (isInterface ? 185 : 182), this.getMethodStyleName(method.getDeclaringClass()), method.getName(), signature);
        this.boxIfPrimitive(mv, method.getReturnType());
        mv.visitInsn(176);
        mv.visitMaxs(2, (isStatic ? 2 : 3) + arguments.length);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private String buildSignatureString(Class<?>[] arguments, Class<?> returnClazz) {
        String sig = "(";
        for (Class<?> arg : arguments) {
            sig = !arg.isPrimitive() ? sig + "L" + this.getMethodStyleName(arg) + ";" : sig + this.getMethodStyleName(arg);
        }
        sig = sig + ")";
        sig = !returnClazz.isPrimitive() ? sig + "L" + this.getMethodStyleName(returnClazz) + ";" : sig + this.getMethodStyleName(returnClazz);
        return sig;
    }

    private Class<?> getObjectVersion(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return inverseTypeMap.get(clazz);
        }
        return clazz;
    }

    private String getMethodStyleName(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz.getCanonicalName().replaceAll("\\.", "/");
        }
        return primitiveSignature.get(clazz);
    }

    private void boxIfPrimitive(MethodVisitor mv, Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return;
        }
        String boxedClass = this.getMethodStyleName(inverseTypeMap.get(clazz));
        mv.visitMethodInsn(184, boxedClass, "valueOf", "(" + this.getMethodStyleName(clazz) + ")L" + boxedClass + ";");
    }

    private void unboxIfPrimitive(MethodVisitor mv, Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return;
        }
        String methodName = clazz.getSimpleName() + "Value";
        mv.visitMethodInsn(182, this.getMethodStyleName(inverseTypeMap.get(clazz)), methodName, "()" + this.getMethodStyleName(clazz));
    }

    private void loadAndStoreArgument(MethodVisitor mv, int loadIdx, int storeIdx, String castName) {
        mv.visitVarInsn(25, 1);
        this.addConst(mv, loadIdx);
        mv.visitMethodInsn(185, "org/apache/pig/data/Tuple", "get", "(I)Ljava/lang/Object;");
        mv.visitTypeInsn(192, castName);
        mv.visitVarInsn(58, storeIdx);
    }

    private void addConst(MethodVisitor mv, int idx) {
        switch (idx) {
            case 0: {
                mv.visitInsn(3);
                break;
            }
            case 1: {
                mv.visitInsn(4);
                break;
            }
            case 2: {
                mv.visitInsn(5);
                break;
            }
            case 3: {
                mv.visitInsn(6);
                break;
            }
            case 4: {
                mv.visitInsn(7);
                break;
            }
            case 5: {
                mv.visitInsn(8);
                break;
            }
            default: {
                throw new RuntimeException("Invalid index given to addConst: " + idx);
            }
        }
    }

    private void makeConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    static class ByteClassLoader
    extends ClassLoader {
        private byte[] buf;

        public ByteClassLoader(byte[] buf) {
            this.buf = buf;
        }

        public Class<InvokerFunction> findClass(String name) {
            return this.defineClass(name, this.buf, 0, this.buf.length);
        }

        public static InvokerFunction getInvokerFunction(String name, byte[] buf) {
            try {
                return new ByteClassLoader(buf).findClass(name).newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

