/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.BulkLoadCellFilter;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.WALCellFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NamespaceTableCfWALEntryFilter
implements WALEntryFilter,
WALCellFilter {
    private final ReplicationPeer peer;
    private BulkLoadCellFilter bulkLoadFilter = new BulkLoadCellFilter();

    public NamespaceTableCfWALEntryFilter(ReplicationPeer peer) {
        this.peer = peer;
    }

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        if (this.peer.getPeerConfig().needToReplicate(entry.getKey().getTableName())) {
            return entry;
        }
        return null;
    }

    @Override
    public Cell filterCell(WAL.Entry entry, Cell cell) {
        ReplicationPeerConfig peerConfig = this.peer.getPeerConfig();
        TableName tableName = entry.getKey().getTableName();
        if (CellUtil.matchingColumn(cell, WALEdit.METAFAMILY, WALEdit.BULK_LOAD)) {
            return this.bulkLoadFilter.filterCell(cell, fam -> !peerConfig.needToReplicate(tableName, (byte[])fam));
        }
        return peerConfig.needToReplicate(tableName, CellUtil.cloneFamily(cell)) ? cell : null;
    }
}

