/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class AMLaunchedEvent
implements HistoryEvent {
    private ApplicationAttemptId applicationAttemptId;
    private long launchTime;
    private long appSubmitTime;
    private String user;

    public AMLaunchedEvent() {
    }

    public AMLaunchedEvent(ApplicationAttemptId appAttemptId, long launchTime, long appSubmitTime, String user) {
        this.applicationAttemptId = appAttemptId;
        this.launchTime = launchTime;
        this.appSubmitTime = appSubmitTime;
        this.user = user;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.AM_LAUNCHED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return false;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public String toString() {
        return "appAttemptId=" + this.applicationAttemptId + ", appSubmitTime=" + this.appSubmitTime + ", launchTime=" + this.launchTime;
    }

    public RecoveryProtos.AMLaunchedProto toProto() {
        return RecoveryProtos.AMLaunchedProto.newBuilder().setApplicationAttemptId(this.applicationAttemptId.toString()).setAppSubmitTime(this.appSubmitTime).setLaunchTime(this.launchTime).build();
    }

    public void fromProto(RecoveryProtos.AMLaunchedProto proto) {
        this.applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)proto.getApplicationAttemptId());
        this.launchTime = proto.getLaunchTime();
        this.appSubmitTime = proto.getAppSubmitTime();
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.AMLaunchedProto proto = (RecoveryProtos.AMLaunchedProto)inputStream.readMessage(RecoveryProtos.AMLaunchedProto.PARSER, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public long getLaunchTime() {
        return this.launchTime;
    }

    public long getAppSubmitTime() {
        return this.appSubmitTime;
    }

    public String getUser() {
        return this.user;
    }
}

