/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.spark;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.tools.pigstats.ScriptState;

public class SparkScriptState
extends ScriptState {
    private SparkScriptInfo scriptInfo = null;

    public SparkScriptState(String id) {
        super(id);
    }

    public void setScriptInfo(SparkOperPlan plan) {
        this.scriptInfo = new SparkScriptInfo(plan);
    }

    public SparkScriptInfo getScriptInfo() {
        return this.scriptInfo;
    }

    public static class SparkScriptInfo {
        private static final Log LOG = LogFactory.getLog(SparkScriptInfo.class);
        private SparkOperPlan sparkPlan;
        private String alias;
        private String aliasLocation;
        private String features;
        private Map<OperatorKey, String> featuresMap = Maps.newHashMap();
        private Map<OperatorKey, String> aliasMap = Maps.newHashMap();
        private Map<OperatorKey, String> aliasLocationMap = Maps.newHashMap();

        public SparkScriptInfo(SparkOperPlan sparkPlan) {
            this.sparkPlan = sparkPlan;
            this.initialize();
        }

        private void initialize() {
            try {
                new DAGAliasVisitor(this.sparkPlan).visit();
            }
            catch (VisitorException e) {
                LOG.warn((Object)"Cannot calculate alias information for DAG", (Throwable)e);
            }
        }

        public String getAlias(SparkOperator sparkOp) {
            return this.aliasMap.get(sparkOp.getOperatorKey());
        }

        public String getAliasLocation(SparkOperator sparkOp) {
            return this.aliasLocationMap.get(sparkOp.getOperatorKey());
        }

        public String getPigFeatures(SparkOperator sparkOp) {
            return this.featuresMap.get(sparkOp.getOperatorKey());
        }

        class DAGAliasVisitor
        extends SparkOpPlanVisitor {
            private Set<String> aliases;
            private Set<String> aliasLocations;
            private BitSet featureSet;

            public DAGAliasVisitor(SparkOperPlan plan) {
                super(plan, (PlanWalker<SparkOperator, SparkOperPlan>)new DependencyOrderWalker<SparkOperator, SparkOperPlan>(plan));
                this.aliases = new HashSet<String>();
                this.aliasLocations = new HashSet<String>();
                this.featureSet = new BitSet();
            }

            @Override
            public void visitSparkOp(SparkOperator sparkOp) throws VisitorException {
                ArrayList<String> aliasList = new ArrayList<String>();
                String aliasLocationStr = "";
                try {
                    ArrayList<String> aliasLocationList = new ArrayList<String>();
                    new ScriptState.AliasVisitor(sparkOp.physicalPlan, aliasList, aliasLocationList).visit();
                    aliasLocationStr = aliasLocationStr + LoadFunc.join(aliasLocationList, ",");
                    if (!aliasList.isEmpty()) {
                        Collections.sort(aliasList);
                        this.aliases.addAll(aliasList);
                        this.aliasLocations.addAll(aliasLocationList);
                    }
                }
                catch (VisitorException e) {
                    LOG.warn((Object)"unable to get alias", (Throwable)e);
                }
                SparkScriptInfo.this.aliasMap.put(sparkOp.getOperatorKey(), LoadFunc.join(aliasList, ","));
                SparkScriptInfo.this.aliasLocationMap.put(sparkOp.getOperatorKey(), aliasLocationStr);
                BitSet feature = new BitSet();
                feature.clear();
                if (sparkOp.isSampler()) {
                    feature.set(ScriptState.PIG_FEATURE.SAMPLER.ordinal());
                }
                if (sparkOp.isIndexer()) {
                    feature.set(ScriptState.PIG_FEATURE.INDEXER.ordinal());
                }
                if (sparkOp.isCogroup()) {
                    feature.set(ScriptState.PIG_FEATURE.COGROUP.ordinal());
                }
                if (sparkOp.isGroupBy()) {
                    feature.set(ScriptState.PIG_FEATURE.GROUP_BY.ordinal());
                }
                if (sparkOp.isRegularJoin()) {
                    feature.set(ScriptState.PIG_FEATURE.HASH_JOIN.ordinal());
                }
                if (sparkOp.isUnion()) {
                    feature.set(ScriptState.PIG_FEATURE.UNION.ordinal());
                }
                if (sparkOp.isNative()) {
                    feature.set(ScriptState.PIG_FEATURE.NATIVE.ordinal());
                }
                if (sparkOp.isLimit() || sparkOp.isLimitAfterSort()) {
                    feature.set(ScriptState.PIG_FEATURE.LIMIT.ordinal());
                }
                try {
                    new ScriptState.FeatureVisitor(sparkOp.physicalPlan, feature).visit();
                }
                catch (VisitorException e) {
                    LOG.warn((Object)"Feature visitor failed", (Throwable)e);
                }
                StringBuilder sb = new StringBuilder();
                int i = feature.nextSetBit(0);
                while (i >= 0) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(ScriptState.PIG_FEATURE.values()[i].name());
                    i = feature.nextSetBit(i + 1);
                }
                SparkScriptInfo.this.featuresMap.put(sparkOp.getOperatorKey(), sb.toString());
                for (i = 0; i < feature.length(); ++i) {
                    if (!feature.get(i)) continue;
                    this.featureSet.set(i);
                }
            }

            @Override
            public void visit() throws VisitorException {
                super.visit();
                if (!this.aliases.isEmpty()) {
                    ArrayList<String> aliasList = new ArrayList<String>(this.aliases);
                    ArrayList<String> aliasLocationList = new ArrayList<String>(this.aliasLocations);
                    Collections.sort(aliasList);
                    Collections.sort(aliasLocationList);
                    SparkScriptInfo.this.alias = LoadFunc.join(aliasList, ",");
                    SparkScriptInfo.this.aliasLocation = LoadFunc.join(aliasLocationList, ",");
                }
                StringBuilder sb = new StringBuilder();
                int i = this.featureSet.nextSetBit(0);
                while (i >= 0) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(ScriptState.PIG_FEATURE.values()[i].name());
                    i = this.featureSet.nextSetBit(i + 1);
                }
                SparkScriptInfo.this.features = sb.toString();
            }
        }
    }
}

