/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.trace.wrappers.RpcServerInvocationHandler;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TBaseProcessor;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcWrapper {
    private static final Logger log = LoggerFactory.getLogger(RpcWrapper.class);

    public static <I> I service(I instance, TBaseProcessor<I> processor) {
        Map processorView = processor.getProcessMapView();
        Set<String> onewayMethods = RpcWrapper.getOnewayMethods(processorView);
        log.debug("Found oneway Thrift methods: " + onewayMethods);
        RpcServerInvocationHandler<I> handler = RpcWrapper.getInvocationHandler(instance, onewayMethods);
        Object proxiedInstance = Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance.getClass().getInterfaces(), handler);
        return (I)proxiedInstance;
    }

    protected static <T> RpcServerInvocationHandler<T> getInvocationHandler(final T instance, final Set<String> onewayMethods) {
        return new RpcServerInvocationHandler<T>(instance){
            private final Logger log;
            {
                super(serverInstance);
                this.log = LoggerFactory.getLogger(instance.getClass());
            }

            public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
                try {
                    return super.invoke(obj, method, args);
                }
                catch (RuntimeException e) {
                    String msg = e.getMessage();
                    this.log.error(msg, (Throwable)e);
                    if (onewayMethods.contains(method.getName())) {
                        throw e;
                    }
                    throw new TException(msg);
                }
                catch (Error e) {
                    String msg = e.getMessage();
                    this.log.error(msg, (Throwable)e);
                    if (onewayMethods.contains(method.getName())) {
                        throw e;
                    }
                    throw new TException(msg);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Set<String> getOnewayMethods(Map<String, ?> processorView) {
        Method isOnewayMethod;
        try {
            isOnewayMethod = ProcessFunction.class.getDeclaredMethod("isOneway", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not access isOneway method", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Could not access isOneway method", e);
        }
        boolean accessible = isOnewayMethod.isAccessible();
        isOnewayMethod.setAccessible(true);
        try {
            HashSet<String> onewayMethods = new HashSet<String>();
            for (Map.Entry<String, ?> entry : processorView.entrySet()) {
                try {
                    if (!((Boolean)isOnewayMethod.invoke(entry.getValue(), new Object[0])).booleanValue()) continue;
                    onewayMethods.add(entry.getKey());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            HashSet<String> hashSet = onewayMethods;
            return hashSet;
        }
        finally {
            isOnewayMethod.setAccessible(accessible);
        }
    }
}

