/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.rules;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.RuleBasedDataGenerator;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

public class SequentialListDataGenerator
implements RuleBasedDataGenerator {
    private final Column columnRule;
    private final AtomicLong counter;

    public SequentialListDataGenerator(Column columnRule) {
        Preconditions.checkArgument(columnRule.getDataSequence() == DataSequence.SEQUENTIAL);
        Preconditions.checkArgument(columnRule.getDataValues().size() > 0);
        Preconditions.checkArgument(this.isAllowedType(columnRule.getType()));
        this.columnRule = columnRule;
        this.counter = new AtomicLong(0L);
    }

    @Override
    public DataValue getDataValue() {
        long pos = this.counter.getAndIncrement();
        int index = (int)pos % this.columnRule.getDataValues().size();
        return this.columnRule.getDataValues().get(index);
    }

    boolean isAllowedType(DataTypeMapping mapping) {
        switch (mapping) {
            case VARCHAR: 
            case VARBINARY: 
            case JSON: 
            case BSON: 
            case CHAR: {
                return true;
            }
        }
        return false;
    }
}

