/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.List;
import java.util.Optional;
import org.apache.maven.api.Repository;
import org.apache.maven.api.Session;
import org.apache.maven.api.Version;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.VersionResolver;
import org.apache.maven.api.services.VersionResolverException;
import org.apache.maven.api.services.VersionResolverRequest;
import org.apache.maven.api.services.VersionResolverResult;
import org.apache.maven.impl.DefaultLocalRepository;
import org.apache.maven.impl.DefaultRemoteRepository;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.impl.RequestTraceHelper;
import org.apache.maven.impl.Utils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;

@Named
@Singleton
public class DefaultVersionResolver
implements VersionResolver {
    private final RepositorySystem repositorySystem;

    @Inject
    public DefaultVersionResolver(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    public VersionResolverResult resolve(VersionResolverRequest request) throws VersionResolverException {
        Utils.nonNull(request, "request");
        InternalSession session = InternalSession.from((Session)request.getSession());
        return session.request(request, this::doResolve);
    }

    protected VersionResolverResult doResolve(final VersionResolverRequest request) throws VersionResolverException {
        final InternalSession session = InternalSession.from((Session)request.getSession());
        RequestTraceHelper.ResolverTrace trace = RequestTraceHelper.enter(session, request);
        try {
            VersionRequest req = new VersionRequest(session.toArtifact(request.getArtifactCoordinates()), session.toRepositories(request.getRepositories() != null ? request.getRepositories() : session.getRemoteRepositories()), trace.context()).setTrace(trace.trace());
            final VersionResult res = this.repositorySystem.resolveVersion(session.getSession(), req);
            VersionResolverResult versionResolverResult = new VersionResolverResult(){

                public VersionResolverRequest getRequest() {
                    return request;
                }

                public List<Exception> getExceptions() {
                    return res.getExceptions();
                }

                public Version getVersion() {
                    return session.parseVersion(res.getVersion());
                }

                public Optional<Repository> getRepository() {
                    ArtifactRepository artifactRepository = res.getRepository();
                    if (artifactRepository instanceof LocalRepository) {
                        LocalRepository localRepository = (LocalRepository)artifactRepository;
                        return Optional.of(new DefaultLocalRepository(localRepository));
                    }
                    artifactRepository = res.getRepository();
                    if (artifactRepository instanceof RemoteRepository) {
                        RemoteRepository remoteRepository = (RemoteRepository)artifactRepository;
                        return Optional.of(new DefaultRemoteRepository(remoteRepository));
                    }
                    return Optional.empty();
                }
            };
            return versionResolverResult;
        }
        catch (VersionResolutionException e) {
            throw new VersionResolverException("Unable to resolve version", (Throwable)e);
        }
        finally {
            RequestTraceHelper.exit(trace);
        }
    }
}

