/*
 * Decompiled with CFR 0.152.
 */
package org.jline.consoleui.prompt.builder;

import java.util.ArrayList;
import java.util.List;
import org.jline.consoleui.elements.ListChoice;
import org.jline.consoleui.elements.PageSizeType;
import org.jline.consoleui.elements.items.ListItemIF;
import org.jline.consoleui.elements.items.impl.ListItem;
import org.jline.consoleui.prompt.builder.ListItemBuilder;
import org.jline.consoleui.prompt.builder.PromptBuilder;

public class ListPromptBuilder {
    private final PromptBuilder promptBuilder;
    private String name;
    private String message;
    private int pageSize;
    private PageSizeType pageSizeType;
    private final List<ListItemIF> itemList = new ArrayList<ListItemIF>();

    public ListPromptBuilder(PromptBuilder promptBuilder) {
        this.promptBuilder = promptBuilder;
        this.pageSize = 10;
        this.pageSizeType = PageSizeType.ABSOLUTE;
    }

    public ListPromptBuilder name(String name) {
        this.name = name;
        if (this.message != null) {
            this.message = name;
        }
        return this;
    }

    public ListPromptBuilder message(String message) {
        this.message = message;
        if (this.name == null) {
            this.name = message;
        }
        return this;
    }

    public ListPromptBuilder pageSize(int absoluteSize) {
        this.pageSize = absoluteSize;
        this.pageSizeType = PageSizeType.ABSOLUTE;
        return this;
    }

    public ListPromptBuilder relativePageSize(int relativePageSize) {
        this.pageSize = relativePageSize;
        this.pageSizeType = PageSizeType.RELATIVE;
        return this;
    }

    public ListItemBuilder newItem() {
        return new ListItemBuilder(this);
    }

    public ListItemBuilder newItem(String name) {
        ListItemBuilder listItemBuilder = new ListItemBuilder(this);
        return listItemBuilder.name(name).text(name);
    }

    public PromptBuilder addPrompt() {
        ListChoice listChoice = new ListChoice(this.message, this.name, this.pageSize, this.pageSizeType, this.itemList);
        this.promptBuilder.addPrompt(listChoice);
        return this.promptBuilder;
    }

    void addItem(ListItem listItem) {
        this.itemList.add(listItem);
    }
}

