/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;

public class DummyTotalHitCountCollector
implements Collector {
    private int totalHits;

    public int getTotalHits() {
        return this.totalHits;
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return new LeafCollector(){

            public void setScorer(Scorable scorer) throws IOException {
            }

            public void collect(int doc) throws IOException {
                ++DummyTotalHitCountCollector.this.totalHits;
            }
        };
    }

    public static CollectorManager<DummyTotalHitCountCollector, Integer> createManager() {
        return new CollectorManager<DummyTotalHitCountCollector, Integer>(){

            public DummyTotalHitCountCollector newCollector() throws IOException {
                return new DummyTotalHitCountCollector();
            }

            public Integer reduce(Collection<DummyTotalHitCountCollector> collectors) throws IOException {
                int sum = 0;
                for (DummyTotalHitCountCollector coll : collectors) {
                    sum += coll.totalHits;
                }
                return sum;
            }
        };
    }
}

