/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene90;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public final class Lucene90FieldInfosFormat
extends FieldInfosFormat {
    static final String EXTENSION = "fnm";
    static final String CODEC_NAME = "Lucene90FieldInfos";
    static final int FORMAT_START = 0;
    static final int FORMAT_CURRENT = 0;
    static final byte STORE_TERMVECTOR = 1;
    static final byte OMIT_NORMS = 2;
    static final byte STORE_PAYLOADS = 4;
    static final byte SOFT_DELETES_FIELD = 8;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)segmentInfo.name, (String)segmentSuffix, (String)EXTENSION);
        try (ChecksumIndexInput input = directory.openChecksumInput(fileName);){
            Throwable priorE = null;
            FieldInfo[] infos = null;
            try {
                CodecUtil.checkIndexHeader((DataInput)input, (String)CODEC_NAME, (int)0, (int)0, (byte[])segmentInfo.getId(), (String)segmentSuffix);
                int size = input.readVInt();
                infos = new FieldInfo[size];
                Map lastAttributes = Collections.emptyMap();
                for (int i = 0; i < size; ++i) {
                    int pointNumBytes;
                    int pointDataDimensionCount;
                    String name = input.readString();
                    int fieldNumber = input.readVInt();
                    if (fieldNumber < 0) {
                        throw new CorruptIndexException("invalid field number for field: " + name + ", fieldNumber=" + fieldNumber, (DataInput)input);
                    }
                    byte bits = input.readByte();
                    boolean storeTermVector = (bits & 1) != 0;
                    boolean omitNorms = (bits & 2) != 0;
                    boolean storePayloads = (bits & 4) != 0;
                    boolean isSoftDeletesField = (bits & 8) != 0;
                    IndexOptions indexOptions = Lucene90FieldInfosFormat.getIndexOptions((IndexInput)input, input.readByte());
                    DocValuesType docValuesType = Lucene90FieldInfosFormat.getDocValuesType((IndexInput)input, input.readByte());
                    long dvGen = input.readLong();
                    Map attributes = input.readMapOfStrings();
                    if (attributes.equals(lastAttributes)) {
                        attributes = lastAttributes;
                    }
                    lastAttributes = attributes;
                    int pointIndexDimensionCount = pointDataDimensionCount = input.readVInt();
                    if (pointDataDimensionCount != 0) {
                        pointIndexDimensionCount = input.readVInt();
                        pointNumBytes = input.readVInt();
                    } else {
                        pointNumBytes = 0;
                    }
                    int vectorDimension = input.readVInt();
                    VectorSimilarityFunction vectorDistFunc = Lucene90FieldInfosFormat.getDistFunc((IndexInput)input, input.readByte());
                    try {
                        infos[i] = new FieldInfo(name, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, DocValuesSkipIndexType.NONE, dvGen, attributes, pointDataDimensionCount, pointIndexDimensionCount, pointNumBytes, vectorDimension, VectorEncoding.FLOAT32, vectorDistFunc, isSoftDeletesField, false);
                        infos[i].checkConsistency();
                        continue;
                    }
                    catch (IllegalStateException e) {
                        throw new CorruptIndexException("invalid fieldinfo for field: " + name + ", fieldNumber=" + fieldNumber, (DataInput)input, (Throwable)e);
                    }
                }
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter((ChecksumIndexInput)input, (Throwable)priorE);
            }
            FieldInfos fieldInfos = new FieldInfos(infos);
            return fieldInfos;
        }
    }

    private static byte docValuesByte(DocValuesType type) {
        switch (type) {
            case NONE: {
                return 0;
            }
            case NUMERIC: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case SORTED: {
                return 3;
            }
            case SORTED_SET: {
                return 4;
            }
            case SORTED_NUMERIC: {
                return 5;
            }
        }
        throw new AssertionError((Object)("unhandled DocValuesType: " + String.valueOf(type)));
    }

    private static DocValuesType getDocValuesType(IndexInput input, byte b) throws IOException {
        switch (b) {
            case 0: {
                return DocValuesType.NONE;
            }
            case 1: {
                return DocValuesType.NUMERIC;
            }
            case 2: {
                return DocValuesType.BINARY;
            }
            case 3: {
                return DocValuesType.SORTED;
            }
            case 4: {
                return DocValuesType.SORTED_SET;
            }
            case 5: {
                return DocValuesType.SORTED_NUMERIC;
            }
        }
        throw new CorruptIndexException("invalid docvalues byte: " + b, (DataInput)input);
    }

    private static VectorSimilarityFunction getDistFunc(IndexInput input, byte b) throws IOException {
        if (b < 0 || b >= VectorSimilarityFunction.values().length) {
            throw new CorruptIndexException("invalid distance function: " + b, (DataInput)input);
        }
        return VectorSimilarityFunction.values()[b];
    }

    private static byte indexOptionsByte(IndexOptions indexOptions) {
        switch (indexOptions) {
            case NONE: {
                return 0;
            }
            case DOCS: {
                return 1;
            }
            case DOCS_AND_FREQS: {
                return 2;
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return 3;
            }
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return 4;
            }
        }
        throw new AssertionError((Object)("unhandled IndexOptions: " + String.valueOf(indexOptions)));
    }

    private static IndexOptions getIndexOptions(IndexInput input, byte b) throws IOException {
        switch (b) {
            case 0: {
                return IndexOptions.NONE;
            }
            case 1: {
                return IndexOptions.DOCS;
            }
            case 2: {
                return IndexOptions.DOCS_AND_FREQS;
            }
            case 3: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            case 4: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            }
        }
        throw new CorruptIndexException("invalid IndexOptions byte: " + b, (DataInput)input);
    }

    public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)segmentInfo.name, (String)segmentSuffix, (String)EXTENSION);
        try (IndexOutput output = directory.createOutput(fileName, context);){
            CodecUtil.writeIndexHeader((DataOutput)output, (String)CODEC_NAME, (int)0, (byte[])segmentInfo.getId(), (String)segmentSuffix);
            output.writeVInt(infos.size());
            for (FieldInfo fi : infos) {
                fi.checkConsistency();
                output.writeString(fi.name);
                output.writeVInt(fi.number);
                byte bits = 0;
                if (fi.hasTermVectors()) {
                    bits = (byte)(bits | 1);
                }
                if (fi.omitsNorms()) {
                    bits = (byte)(bits | 2);
                }
                if (fi.hasPayloads()) {
                    bits = (byte)(bits | 4);
                }
                if (fi.isSoftDeletesField()) {
                    bits = (byte)(bits | 8);
                }
                output.writeByte(bits);
                output.writeByte(Lucene90FieldInfosFormat.indexOptionsByte(fi.getIndexOptions()));
                output.writeByte(Lucene90FieldInfosFormat.docValuesByte(fi.getDocValuesType()));
                output.writeLong(fi.getDocValuesGen());
                output.writeMapOfStrings(fi.attributes());
                output.writeVInt(fi.getPointDimensionCount());
                if (fi.getPointDimensionCount() != 0) {
                    output.writeVInt(fi.getPointIndexDimensionCount());
                    output.writeVInt(fi.getPointNumBytes());
                }
                output.writeVInt(fi.getVectorDimension());
                output.writeByte((byte)fi.getVectorSimilarityFunction().ordinal());
            }
            CodecUtil.writeFooter((IndexOutput)output);
        }
    }

    static {
        boolean bl = $assertionsDisabled = !Lucene90FieldInfosFormat.class.desiredAssertionStatus();
        if (!$assertionsDisabled && DocValuesType.values().length != 6) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && IndexOptions.values().length != 5) {
            throw new AssertionError();
        }
    }
}

